/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.checkout.CheckoutController;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.tfvc.ui.checkout.TfvcCheckoutModel;
import git4idea.actions.BasicAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfvcCheckoutProvider
implements CheckoutProvider {
    private final Logger logger = LoggerFactory.getLogger(TfvcCheckoutProvider.class);

    public String getVcsName() {
        return TfPluginBundle.message("Providers.TfvcCheckoutProvider", new Object[0]);
    }

    public void doCheckout(@NotNull Project project, CheckoutProvider.Listener listener) {
        BasicAction.saveAll();
        if (!IdeaHelper.isTFConfigured(project)) {
            return;
        }
        try {
            CheckoutController controller = new CheckoutController(project, listener, new TfvcCheckoutModel());
            controller.showModalDialog();
        }
        catch (Throwable t) {
            this.logger.warn("doCheckout failed unexpectedly", t);
            VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("CheckoutDialog.Title", new Object[0]), TfPluginBundle.message("Checkout.Errors.Unexpected", t.getMessage()));
        }
    }
}

