/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.ApplyLabelForm;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ApplyLabelDialog
extends BaseDialogImpl {
    public static final String PROP_ITEMS = "items";
    private ApplyLabelForm form;

    public ApplyLabelDialog(Project project, List<ItemInfo> itemInfos) {
        super(project, TfPluginBundle.message("Tfvc.Label.Dialog.Title", new Object[0]), TfPluginBundle.message("Tfvc.Label.Dialog.ApplyLabel", new Object[0]), "Tfvc.Label.Dialog.Title", true, Collections.singletonMap(PROP_ITEMS, itemInfos));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.form.getPreferredFocusedComponent();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.form = new ApplyLabelForm(this.getProject(), (List)this.getProperty(PROP_ITEMS));
        this.setOkEnabled(false);
        this.form.addListener(new ApplyLabelForm.Listener(){

            @Override
            public void dataChanged(String labelName, int visibleItemsCount) {
                ApplyLabelDialog.this.setOkEnabled(visibleItemsCount > 0 && labelName.length() > 0);
            }
        });
        return this.form.getContentPane();
    }

    public String getLabelName() {
        return this.form.getLabelName();
    }

    public String getLabelComment() {
        return this.form.getLabelComment();
    }

    public boolean isRecursiveChecked() {
        return this.form.isRecursiveChecked();
    }

    public List<String> getLabelItemSpecs() {
        return this.form.getLabelItemSpecs();
    }
}

