/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.tfvc.ui.LabelItemsTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ApplyLabelForm {
    private final Project project;
    private final List<ItemInfo> itemInfos;
    private JPanel contentPane;
    private JTextField nameText;
    private JTextArea commentTextArea;
    private JTable itemsTable;
    private JButton addButton;
    private JButton removeButton;
    private JCheckBox recursiveCheckBox;
    private LabelItemsTableModel itemsTableModel;
    private final EventDispatcher<Listener> eventDispatcher;

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.NameLabel"));
        this.contentPane.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.nameText = new JTextField();
        this.contentPane.add((Component)this.nameText, new GridConstraints(1, 0, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.CommentLabel"));
        this.contentPane.add((Component)label2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.ItemsLabel"));
        this.contentPane.add((Component)label3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.addButton = new JButton();
        this.$$$loadButtonText$$$(this.addButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.AddButton"));
        panel1.add((Component)this.addButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.removeButton = new JButton();
        this.removeButton.setEnabled(false);
        this.$$$loadButtonText$$$(this.removeButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.RemoveButton"));
        panel1.add((Component)this.removeButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.contentPane.add((Component)jBScrollPane1, new GridConstraints(6, 0, 1, 1, 0, 3, 5, 5, null, new Dimension(-1, 250), null, 0, false));
        this.itemsTable = new JBTable();
        jBScrollPane1.setViewportView((Component)this.itemsTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        this.contentPane.add((Component)jBScrollPane2, new GridConstraints(3, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        this.commentTextArea = new JTextArea();
        this.commentTextArea.setRows(4);
        jBScrollPane2.setViewportView((Component)this.commentTextArea);
        this.recursiveCheckBox = new JCheckBox();
        this.recursiveCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(this.recursiveCheckBox, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ApplyLabelDialog.RecursiveCheckBox"));
        this.contentPane.add((Component)this.recursiveCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        label1.setLabelFor(this.nameText);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public ApplyLabelForm(Project project, List<ItemInfo> itemInfos) {
        this.$$$setupUI$$$();
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.project = project;
        this.itemInfos = itemInfos;
        this.nameText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ApplyLabelForm.this.eventDispatcher.getMulticaster()).dataChanged(ApplyLabelForm.this.getLabelName(), ApplyLabelForm.this.itemsTableModel.getRowCount());
            }
        });
        this.addButton.setVisible(false);
        this.removeButton.setVisible(false);
        this.initTable();
        this.updateButtons();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.nameText;
    }

    private void initTable() {
        this.itemsTableModel = new LabelItemsTableModel();
        this.itemsTableModel.setItems(this.itemInfos);
        this.itemsTable.setModel(this.itemsTableModel);
        for (int i = 0; i < LabelItemsTableModel.Column.values().length; ++i) {
            this.itemsTable.getColumnModel().getColumn(i).setPreferredWidth(LabelItemsTableModel.Column.values()[i].getWidth());
            if (i <= 0) continue;
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setHorizontalAlignment(0);
            this.itemsTable.getColumnModel().getColumn(i).setCellRenderer(typeRenderer);
        }
        this.itemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ApplyLabelForm.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public String getLabelName() {
        return this.nameText.getText().trim();
    }

    public String getLabelComment() {
        return this.commentTextArea.getText();
    }

    public boolean isRecursiveChecked() {
        return this.recursiveCheckBox.isSelected();
    }

    public List<String> getLabelItemSpecs() {
        ArrayList<String> itemSpecs = new ArrayList<String>();
        for (ItemInfo info : this.itemInfos) {
            itemSpecs.add(info.getServerItem() + ";" + info.getServerVersion());
        }
        return itemSpecs;
    }

    public void addListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public static interface Listener
    extends EventListener {
        public void dataChanged(String var1, int var2);
    }
}

