/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.ServerBrowserDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;

public class CreateBranchForm {
    private JTextField sourceText;
    private JCheckBox syncNewBranchCheckBox;
    private TextFieldWithBrowseButton.NoPathCompletion targetText;
    private JPanel contentPane;
    private JLabel targetLabel;
    private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

    public CreateBranchForm(final Project project, final ServerContext serverContext, String serverPath, boolean isDirectory) {
        this.$$$setupUI$$$();
        this.sourceText.setText(serverPath);
        this.targetLabel.setLabelFor(this.targetText.getChildComponent());
        this.targetText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverPath = StringUtils.isNotEmpty((String)CreateBranchForm.this.targetText.getText()) ? CreateBranchForm.this.targetText.getText() : CreateBranchForm.this.sourceText.getText();
                ServerBrowserDialog dialog = new ServerBrowserDialog(TfPluginBundle.message("Actions.Tfvc.Branch.Browse.Title", new Object[0]), project, serverContext, serverPath, true, true);
                if (dialog.showAndGet()) {
                    CreateBranchForm.this.targetText.setText(dialog.getSelectedPath());
                }
            }
        });
        ((JTextField)this.targetText.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)CreateBranchForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(e));
            }
        });
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public String getTargetPath() {
        return this.targetText.getText();
    }

    public boolean isCreateWorkingCopies() {
        return this.syncNewBranchCheckBox.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.targetText.getChildComponent();
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchForm.Source"));
        this.contentPane.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.contentPane.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.sourceText = new JTextField();
        this.sourceText.setEditable(false);
        this.sourceText.setEnabled(true);
        this.contentPane.add((Component)this.sourceText, new GridConstraints(1, 0, 1, 2, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.targetLabel = new JLabel();
        this.$$$loadLabelText$$$(this.targetLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchForm.Target"));
        this.contentPane.add((Component)this.targetLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.targetText = new TextFieldWithBrowseButton.NoPathCompletion();
        this.contentPane.add((Component)this.targetText, new GridConstraints(3, 0, 1, 2, 0, 1, 4, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.setVisible(false);
        this.contentPane.add((Component)panel1, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Branch from version"));
        Spacer spacer2 = new Spacer();
        this.contentPane.add((Component)spacer2, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.syncNewBranchCheckBox = new JCheckBox();
        this.syncNewBranchCheckBox.setActionCommand("Create local copy of new branch");
        this.syncNewBranchCheckBox.setLabel("Create local copy of new branch");
        this.$$$loadButtonText$$$(this.syncNewBranchCheckBox, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreateBranchForm.SyncNewBranch"));
        this.contentPane.add((Component)this.syncNewBranchCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        label1.setLabelFor(this.sourceText);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

