/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.tfvc.ui.LockItemsTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class LockItemsForm {
    private JPanel contentPane;
    private JTable lockItemsTable;
    private JRadioButton lockCheckOutRadioButton;
    private JRadioButton lockCheckInRadioButton;
    private JCheckBox recursiveCheckBox;
    private final LockItemsTableModel lockItemsTableModel;

    public LockItemsForm(List<ItemInfo> items) {
        this.$$$setupUI$$$();
        this.lockCheckInRadioButton.setSelected(true);
        this.lockItemsTableModel = new LockItemsTableModel(items);
        this.lockItemsTable.setModel(this.lockItemsTableModel);
        for (int i = 0; i < LockItemsTableModel.Column.values().length; ++i) {
            this.lockItemsTable.getColumnModel().getColumn(i).setPreferredWidth(LockItemsTableModel.Column.values()[i].getWidth());
        }
        this.lockItemsTable.setSelectionMode(0);
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setRadioButtonsEnabled(boolean isEnabled) {
        this.lockCheckInRadioButton.setEnabled(isEnabled);
        this.lockCheckOutRadioButton.setEnabled(isEnabled);
    }

    public List<ItemInfo> getSelectedItems() {
        return this.lockItemsTableModel.getSelectedItems();
    }

    public LockCommand.LockLevel getLockLevel() {
        if (this.lockCheckInRadioButton.isEnabled() && this.lockCheckInRadioButton.isSelected()) {
            return LockCommand.LockLevel.CHECKIN;
        }
        if (this.lockCheckOutRadioButton.isEnabled() && this.lockCheckOutRadioButton.isSelected()) {
            return LockCommand.LockLevel.CHECKOUT;
        }
        return LockCommand.LockLevel.NONE;
    }

    public boolean getRecursive() {
        return this.recursiveCheckBox.isSelected();
    }

    public void addListener(LockItemsTableModel.Listener listener) {
        this.lockItemsTableModel.addListener(listener);
    }

    public void removeListener(LockItemsTableModel.Listener listener) {
        this.lockItemsTableModel.removeListener(listener);
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel1, "South");
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.LockBox")));
        this.lockCheckInRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.lockCheckInRadioButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.CheckinRadio"));
        panel1.add((Component)this.lockCheckInRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.lockCheckOutRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(this.lockCheckOutRadioButton, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.CheckoutRadio"));
        panel1.add((Component)this.lockCheckOutRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.recursiveCheckBox = new JCheckBox();
        this.recursiveCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(this.recursiveCheckBox, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.RecursiveCheck"));
        panel1.add((Component)this.recursiveCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)panel2, "Center");
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("LockDialog.ItemsBox")));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        panel2.add((Component)jBScrollPane1, "Center");
        this.lockItemsTable = new JBTable();
        this.lockItemsTable.setEnabled(true);
        this.lockItemsTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
        jBScrollPane1.setViewportView((Component)this.lockItemsTable);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.lockCheckInRadioButton);
        buttonGroup.add(this.lockCheckOutRadioButton);
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

