/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LockItemsTableModel
extends AbstractTableModel {
    private final List<ExtendedItemInfo> items;
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);

    public LockItemsTableModel(@NotNull List<ItemInfo> items) {
        this.items = new ArrayList<ExtendedItemInfo>(items.size());
        for (ItemInfo item : items) {
            this.items.add(new ExtendedItemInfo(item));
        }
        this.setInitialSelection();
    }

    private void setInitialSelection() {
        if (this.items != null && this.items.size() > 0) {
            LockCommand.LockLevel firstItemLevel = LockCommand.LockLevel.fromString((String)this.items.get((int)0).info.getLock());
            boolean selectIfNone = firstItemLevel == LockCommand.LockLevel.NONE;
            for (ExtendedItemInfo item : this.items) {
                LockCommand.LockLevel currentLevel = LockCommand.LockLevel.fromString((String)item.info.getLock());
                if (currentLevel == LockCommand.LockLevel.NONE && selectIfNone) {
                    item.selected = true;
                    continue;
                }
                if (currentLevel != LockCommand.LockLevel.NONE && !selectIfNone) {
                    item.selected = true;
                    continue;
                }
                item.selected = false;
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int column) {
        return Column.values()[column].getName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex] == Column.Selection;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        return Column.values()[columnIndex].getValue(this.items.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (Column.values()[columnIndex] == Column.Selection) {
            this.items.get((int)rowIndex).selected = (Boolean)aValue;
            ((Listener)this.myEventDispatcher.getMulticaster()).selectionChanged();
        }
    }

    public List<ItemInfo> getSelectedItems() {
        ArrayList<ItemInfo> result = new ArrayList<ItemInfo>();
        for (ExtendedItemInfo item : this.items) {
            if (!item.selected) continue;
            result.add(item.info);
        }
        return result;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == Column.Selection.ordinal()) {
            return Boolean.class;
        }
        return super.getColumnClass(columnIndex);
    }

    private class ExtendedItemInfo {
        public final ItemInfo info;
        public boolean selected;

        public ExtendedItemInfo(ItemInfo info) {
            this.info = info;
        }
    }

    static enum Column {
        Selection("", 25){

            @Override
            public Boolean getValue(ExtendedItemInfo item) {
                return item.selected;
            }
        }
        ,
        Item(TfPluginBundle.message("Tfvc.Lock.Dialog.ItemColumn", new Object[0]), 550){

            @Override
            public String getValue(ExtendedItemInfo item) {
                return item.info.getServerItem();
            }
        }
        ,
        Lock(TfPluginBundle.message("Tfvc.Lock.Dialog.LockColumn", new Object[0]), 110){

            @Override
            public String getValue(ExtendedItemInfo item) {
                LockCommand.LockLevel level = LockCommand.LockLevel.fromString((String)item.info.getLock());
                switch (level) {
                    case CHECKIN: {
                        return TfPluginBundle.message("Tfvc.Lock.Dialog.LockLevel.Checkin", new Object[0]);
                    }
                    case CHECKOUT: {
                        return TfPluginBundle.message("Tfvc.Lock.Dialog.LockLevel.Checkout", new Object[0]);
                    }
                }
                return "";
            }
        }
        ,
        LockOwner(TfPluginBundle.message("Tfvc.Lock.Dialog.LockedByColumn", new Object[0]), 130){

            @Override
            public String getValue(ExtendedItemInfo item) {
                return item.info.getLockOwner();
            }
        };

        private final String name;
        private final int width;

        private Column(String name, int width) {
            this.name = name;
            this.width = JBUI.scale((int)width);
        }

        public String getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        @Nullable
        public abstract Object getValue(ExtendedItemInfo var1);
    }

    public static interface Listener
    extends EventListener {
        public void selectionChanged();
    }
}

