/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui;

import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.alm.common.utils.UrlHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ProxySettingsForm {
    private JPanel myContentPane;
    private JRadioButton noProxyRadio;
    private JRadioButton useProxyRadio;
    private JTextField addressText;
    private JLabel messageLabel;
    private JLabel infoLabel;
    private JLabel addressLabel;
    private final EventDispatcher<Listener> myEventDispatcher;

    private void $$$setupUI$$$() {
        this.myContentPane = new JPanel();
        this.myContentPane.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myContentPane.add((Component)spacer1, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.addressText = new JTextField();
        this.myContentPane.add((Component)this.addressText, new GridConstraints(2, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.addressLabel = new JLabel();
        this.$$$loadLabelText$$$(this.addressLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.Address"));
        this.myContentPane.add((Component)this.addressLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2, false));
        this.useProxyRadio = new JRadioButton();
        this.$$$loadButtonText$$$(this.useProxyRadio, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.UseProxy"));
        this.myContentPane.add((Component)this.useProxyRadio, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.noProxyRadio = new JRadioButton();
        this.$$$loadButtonText$$$(this.noProxyRadio, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("ProxySettingsDialog.NoProxy"));
        this.myContentPane.add((Component)this.noProxyRadio, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.messageLabel = new JLabel();
        this.messageLabel.setForeground(new Color(-65536));
        this.messageLabel.setText(" ");
        this.myContentPane.add((Component)this.messageLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, new Dimension(300, -1), null, null, 0, false));
        this.infoLabel = new JLabel();
        this.infoLabel.setText("");
        this.myContentPane.add((Component)this.infoLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2, false));
        this.addressLabel.setLabelFor(this.addressText);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.noProxyRadio);
        buttonGroup.add(this.useProxyRadio);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public ProxySettingsForm(String initialProxyUri) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        if (StringUtils.isEmpty((String)initialProxyUri)) {
            this.noProxyRadio.setSelected(true);
        } else {
            this.useProxyRadio.setSelected(true);
            this.addressText.setText(initialProxyUri.toString());
        }
        ActionListener radioButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsForm.this.updateContols();
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        };
        this.noProxyRadio.addActionListener(radioButtonListener);
        this.useProxyRadio.addActionListener(radioButtonListener);
        this.addressText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)ProxySettingsForm.this.myEventDispatcher.getMulticaster()).stateChanged();
            }
        });
        this.infoLabel.setText("");
        this.updateContols();
    }

    private void updateContols() {
        this.addressText.setEnabled(this.useProxyRadio.isSelected());
        this.infoLabel.setEnabled(this.useProxyRadio.isSelected());
        this.addressLabel.setEnabled(this.useProxyRadio.isSelected());
        if (this.useProxyRadio.isSelected()) {
            this.addressText.requestFocus();
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isValid() {
        return this.noProxyRadio.isSelected() || UrlHelper.isValidUrl((String)this.addressText.getText());
    }

    @Nullable
    public String getProxyUri() {
        if (this.noProxyRadio.isSelected()) {
            return null;
        }
        return this.addressText.getText().trim();
    }

    public void setMessage(@Nullable String message) {
        this.messageLabel.setText(message);
    }

    public static interface Listener
    extends EventListener {
        public void stateChanged();
    }
}

