/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.resolve;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.conflicts.ResolveConflictHelper;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ResolveConflictsDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.resolve.ResolveConflictsModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

public class ResolveConflictsController
implements Observer,
ActionListener {
    private final ResolveConflictsDialog dialog;
    private final ResolveConflictsModel model;

    public ResolveConflictsController(Project project, ResolveConflictHelper conflictHelper) {
        this(new ResolveConflictsDialog(project), new ResolveConflictsModel(project, conflictHelper));
    }

    public ResolveConflictsController(ResolveConflictsDialog dialog, ResolveConflictsModel model) {
        this.dialog = dialog;
        this.model = model;
        this.dialog.addActionListener(this);
        this.model.addObserver(this);
        this.model.loadConflicts();
        this.update(null, null);
    }

    public boolean showModalDialog() {
        return this.dialog.showModalDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        if ("acceptTheirs".equals(e.getActionCommand())) {
            this.model.acceptTheirs(this.dialog.getSelectedRows());
        } else if ("acceptYours".equals(e.getActionCommand())) {
            this.model.acceptYours(this.dialog.getSelectedRows());
        } else if ("merge".equals(e.getActionCommand())) {
            this.model.merge(this.dialog.getSelectedRows());
        } else if ("ok".equals(e.getActionCommand())) {
            this.model.processSkippedConflicts();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == null) {
            this.dialog.setConflictsTableModel(this.model.getConflictsTableModel());
        }
        if ("errors".equals(arg)) {
            if (this.model.hasErrors()) {
                this.dialog.displayError(this.model.getErrors().get(0).getValidationMessage());
            } else {
                this.dialog.displayError(null);
            }
        }
    }

    protected void updateModel() {
        this.model.clearErrors();
    }
}

