/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.microsoft.alm.plugin.idea.common.actions.InstrumentedAction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeForm;
import java.awt.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVirtualFolderAction
extends InstrumentedAction {
    public static Logger logger = LoggerFactory.getLogger(CreateVirtualFolderAction.class);

    public CreateVirtualFolderAction() {
        super(false);
    }

    @Override
    public void doUpdate(AnActionEvent e) {
        boolean isEnabled = CreateVirtualFolderAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(isEnabled);
        } else {
            e.getPresentation().setEnabled(isEnabled);
        }
    }

    private static boolean isEnabled(AnActionEvent e) {
        TfsTreeForm form = (TfsTreeForm)TfsTreeForm.KEY.getData(e.getDataContext());
        return form != null && form.getSelectedItem() != null && form.canCreateVirtualFolders();
    }

    @Override
    public void doActionPerformed(AnActionEvent e) {
        TfsTreeForm form = (TfsTreeForm)TfsTreeForm.KEY.getData(e.getDataContext());
        String folderName = Messages.showInputDialog((Component)form.getContentPane(), (String)TfPluginBundle.message("Tfvc.Server.Tree.Create.Folder.Msg", new Object[0]), (String)TfPluginBundle.message("Tfvc.Server.Tree.Create.Folder.Title", new Object[0]), null);
        if (StringUtil.isEmpty((String)folderName)) {
            logger.info("No folder name was found");
            return;
        }
        logger.info("Creating a new vrtual folder");
        form.createVirtualFolder(folderName);
    }
}

