/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.HashMap;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeForm;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class ServerBrowserDialog
extends BaseDialogImpl {
    private static final String PROP_SERVER_CONTEXT = "server_context";
    private static final String PROP_INITIAL_PATH = "initial_path";
    private static final String PROP_FOLDERS_ONLY = "folders_only";
    private static final String PROP_CAN_CREATE_VIRTUAL_FOLDERS = "can_create_virtual_folders";
    private TfsTreeForm treeForm;

    public ServerBrowserDialog(String title, Project project, ServerContext serverContext, @Nullable String initialPath, boolean foldersOnly, boolean canCreateVirtualFolders) {
        super(project, title, TfPluginBundle.message("Tfvc.Server.Tree.Select.Button", new Object[0]), title, true, ServerBrowserDialog.createProperties(serverContext, initialPath, foldersOnly, canCreateVirtualFolders));
    }

    private static Map<String, Object> createProperties(ServerContext serverContext, String initialPath, boolean foldersOnly, boolean canCreateVirtualFolders) {
        HashMap properties = new HashMap(4);
        properties.put(PROP_SERVER_CONTEXT, serverContext);
        properties.put(PROP_INITIAL_PATH, initialPath);
        properties.put(PROP_FOLDERS_ONLY, foldersOnly);
        properties.put(PROP_CAN_CREATE_VIRTUAL_FOLDERS, canCreateVirtualFolders);
        return properties;
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.treeForm = new TfsTreeForm();
        this.treeForm.initialize((ServerContext)this.getProperty(PROP_SERVER_CONTEXT), (String)this.getProperty(PROP_INITIAL_PATH), (Boolean)this.getProperty(PROP_FOLDERS_ONLY), (Boolean)this.getProperty(PROP_CAN_CREATE_VIRTUAL_FOLDERS), null);
        this.treeForm.addListener(new TfsTreeForm.SelectionListener(){

            @Override
            public void selectionChanged() {
                ServerBrowserDialog.this.setOkEnabled(ServerBrowserDialog.this.treeForm.getSelectedItem() != null);
            }
        });
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.treeForm);
        return this.treeForm.getContentPane();
    }

    @Nullable
    public String getSelectedPath() {
        return this.treeForm.getSelectedPath();
    }

    @Nullable
    public TfsTreeForm.SelectedItem getSelectedItem() {
        return this.treeForm.getSelectedItem();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.treeForm.getPreferredFocusedComponent();
    }
}

