/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.openapi.util.Condition;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.rest.VersionControlRecursionTypeCaseSensitive;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcItem;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcVersionDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsTreeContext {
    public static Logger logger = LoggerFactory.getLogger(TfsTreeContext.class);
    public final ServerContext serverContext;
    private final boolean foldersOnly;
    @Nullable
    private final Condition<String> filter;

    public TfsTreeContext(ServerContext serverContext, boolean foldersOnly, Condition<String> filter) {
        this.serverContext = serverContext;
        this.foldersOnly = foldersOnly;
        this.filter = filter;
    }

    public boolean isAccepted(String path) {
        return this.filter == null || this.filter.value((Object)path);
    }

    public List<TfvcItem> getChildItems(String path) throws TfsException {
        if (this.serverContext == null || this.serverContext.getTeamProjectReference() == null) {
            logger.warn("Context and/or project could not be determined so can't get server tree | context is null: " + (this.serverContext == null));
            throw new TfsException(TfPluginBundle.message("Tfvc.Server.Tree.Error", new Object[0]));
        }
        try {
            List items = this.serverContext.getTfvcHttpClient().getItems(this.serverContext.getTeamProjectReference().getId(), path, VersionControlRecursionTypeCaseSensitive.ONE_LEVEL, new TfvcVersionDescriptor());
            TfvcItem parentItem = null;
            for (TfvcItem item : items) {
                if (!StringUtils.equals((String)item.getPath(), (String)path)) continue;
                logger.info("Parent item found and being removed from children list");
                parentItem = item;
                break;
            }
            items.remove(parentItem);
            if (this.foldersOnly) {
                logger.info("Filter out children for only folders");
                ArrayList<TfvcItem> folderItems = new ArrayList<TfvcItem>(items.size());
                for (TfvcItem item : items) {
                    if (!item.isFolder()) continue;
                    folderItems.add(item);
                }
                return folderItems;
            }
            return items;
        }
        catch (AssertionError e) {
            logger.warn("Directory was not found on the server: " + path, (Throwable)((Object)e));
            throw new TfsException(TfPluginBundle.message("Tfvc.Server.Tree.Directory.Not.Found", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.warn("Error while getting a directories children", (Throwable)e);
            throw new TfsException(e);
        }
    }
}

