/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.servertree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.exceptions.TfsException;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsErrorTreeNode;
import com.microsoft.alm.plugin.idea.tfvc.ui.servertree.TfsTreeContext;
import com.microsoft.alm.sourcecontrol.webapi.model.TfvcItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TfsTreeNode
extends SimpleNode {
    private static final SimpleTextAttributes VIRTUAL_ATTRS = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
    private final TfsTreeContext treeContext;
    private final String path;
    private final boolean isDirectory;
    private final boolean isVirtual;
    private final Collection<TfsTreeNode> virtualChildren = new ArrayList<TfsTreeNode>();

    public TfsTreeNode(@NotNull Object projectOrComponent, ServerContext serverContext, String base, boolean foldersOnly, @Nullable Condition<String> pathFilter) {
        super(projectOrComponent instanceof Project ? (Project)projectOrComponent : null);
        this.treeContext = new TfsTreeContext(serverContext, foldersOnly, pathFilter);
        this.path = VersionControlPath.getPathToProject(base);
        this.isDirectory = true;
        this.isVirtual = false;
    }

    private TfsTreeNode(TfsTreeNode parent, String path, boolean isDirectory, boolean virtual) {
        super((SimpleNode)parent);
        this.path = path;
        this.isDirectory = isDirectory;
        this.isVirtual = virtual;
        this.treeContext = parent.treeContext;
    }

    public SimpleNode[] getChildren() {
        List<TfvcItem> children;
        if (!this.isDirectory) {
            return NO_CHILDREN;
        }
        try {
            children = this.treeContext.getChildItems(this.path);
        }
        catch (TfsException e) {
            return new SimpleNode[]{new TfsErrorTreeNode(this, e.getMessage())};
        }
        ArrayList<TfsTreeNode> result = new ArrayList<TfsTreeNode>(this.virtualChildren);
        for (TfvcItem childItem : children) {
            result.add(new TfsTreeNode(this, childItem.getPath(), childItem.isFolder(), false));
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    protected void update(PresentationData presentation) {
        if (this.isRoot()) {
            presentation.addText(this.treeContext.serverContext.getUri().getPath(), this.getPlainAttributes());
            presentation.setIcon(Icons.VSLogoSmall);
        } else {
            if (this.isDirectory()) {
                presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                presentation.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.getFileName()).getIcon());
            }
            SimpleTextAttributes attrs = this.isVirtual ? VIRTUAL_ATTRS : (this.treeContext.isAccepted(this.path) ? this.getPlainAttributes() : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            presentation.addText(this.getFileName(), attrs);
        }
    }

    public String getFileName() {
        return VersionControlPath.getLastComponent(this.path);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isRoot() {
        return "$/".equals(this.path);
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    private TfsTreeNode createFakeChild(String name) {
        String childPath = VersionControlPath.getCombinedServerPath(this.path, name);
        return new TfsTreeNode(this, childPath, false, false);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        return new Object[]{this.path};
    }

    @Nullable
    public TfsTreeNode createForSelection(String serverPath) {
        if (StringUtil.isEmpty((String)serverPath) || "$/".equals(serverPath)) {
            return this;
        }
        TfsTreeNode result = this;
        String[] components = VersionControlPath.getPathComponents(serverPath);
        for (int i = 1; i < components.length; ++i) {
            result = result.createFakeChild(components[i]);
        }
        return result;
    }

    public TfsTreeNode createVirtualSubfolder(String folderName) {
        String childPath = VersionControlPath.getCombinedServerPath(this.path, folderName);
        TfsTreeNode child = new TfsTreeNode(this, childPath, true, true);
        this.virtualChildren.add(child);
        return child;
    }
}

