/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.settings;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.plugin.external.exceptions.ToolException;
import com.microsoft.alm.plugin.external.exceptions.ToolVersionException;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class ProjectConfigurableForm {
    private JButton myManageButton;
    private JButton myResetPasswordsButton;
    private final Project myProject;
    private JComponent myContentPane;
    private JCheckBox myUseIdeaHttpProxyCheckBox;
    private JCheckBox myTFSCheckBox;
    private JCheckBox myStatefulCheckBox;
    private JCheckBox myReportNotInstalledPoliciesCheckBox;
    private JPanel serverLabel;
    private JPanel passwordLabel;
    private JPanel checkinPolicyLabel;
    private JLabel noteLabel;
    private JButton testExeButton;
    private TextFieldWithBrowseButton tfExeField;
    private JLabel pathLabel;
    private String originalTfLocation = "";

    public ProjectConfigurableForm(Project project) {
        this.$$$setupUI$$$();
        this.myProject = project;
        this.myResetPasswordsButton.setVisible(false);
        this.myUseIdeaHttpProxyCheckBox.setVisible(false);
        this.myTFSCheckBox.setVisible(false);
        this.myStatefulCheckBox.setVisible(false);
        this.myReportNotInstalledPoliciesCheckBox.setVisible(false);
        this.myResetPasswordsButton.setVisible(false);
        this.serverLabel.setVisible(false);
        this.passwordLabel.setVisible(false);
        this.checkinPolicyLabel.setVisible(false);
        this.noteLabel.setVisible(false);
        this.pathLabel.setText(TfPluginBundle.message("Tfvc.Settings.Description", new Object[0]));
        this.tfExeField.addBrowseFolderListener(TfPluginBundle.message("Tfvc.Settings.Title", new Object[0]), TfPluginBundle.message("Tfvc.Settings.Description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.testExeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", ProjectConfigurableForm.this.getCurrentExecutablePath());
                try {
                    TfTool.checkVersion();
                    Messages.showInfoMessage((Component)ProjectConfigurableForm.this.myContentPane, (String)TfPluginBundle.message("Tfvc.Settings.FoundExe", new Object[0]), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                }
                catch (ToolVersionException e) {
                    Messages.showWarningDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                }
                catch (ToolException e) {
                    Messages.showErrorDialog((Component)ProjectConfigurableForm.this.myContentPane, (String)LocalizationServiceImpl.getInstance().getExceptionMessage(e), (String)TfPluginBundle.message("Tfvc.tf.VersionWarning.Title", new Object[0]));
                }
            }
        });
        this.load();
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    @VisibleForTesting
    protected String getCurrentExecutablePath() {
        return this.tfExeField.getText().trim();
    }

    public void load() {
        String tfLocation = PluginServiceProvider.getInstance().getPropertyService().getProperty("tfHome");
        tfLocation = StringUtils.isEmpty((String)tfLocation) ? TfTool.tryDetectTf() : tfLocation;
        this.originalTfLocation = StringUtils.isEmpty((String)tfLocation) ? "" : tfLocation;
        this.tfExeField.setText(this.originalTfLocation);
    }

    public void apply() {
        PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", this.getCurrentExecutablePath());
    }

    public boolean isModified() {
        return PluginServiceProvider.getInstance().getPropertyService().getProperty("tfHome") != this.getCurrentExecutablePath();
    }

    public void reset() {
        PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", this.originalTfLocation);
        this.tfExeField.setText(this.originalTfLocation);
    }

    private void $$$setupUI$$$() {
        this.myContentPane = new JPanel();
        this.myContentPane.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.serverLabel = new JPanel();
        this.serverLabel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPane.add((Component)this.serverLabel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.serverLabel.setBorder(BorderFactory.createTitledBorder("Servers and workspaces"));
        this.myManageButton = new JButton();
        this.myManageButton.setText("Manage...");
        this.myManageButton.setMnemonic('M');
        this.myManageButton.setDisplayedMnemonicIndex(0);
        this.serverLabel.add((Component)this.myManageButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.serverLabel.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myUseIdeaHttpProxyCheckBox = new JCheckBox();
        this.myUseIdeaHttpProxyCheckBox.setEnabled(true);
        this.myUseIdeaHttpProxyCheckBox.setSelected(false);
        this.myUseIdeaHttpProxyCheckBox.setText("Use HTTP Proxy settings");
        this.myUseIdeaHttpProxyCheckBox.setMnemonic('U');
        this.myUseIdeaHttpProxyCheckBox.setDisplayedMnemonicIndex(0);
        this.serverLabel.add((Component)this.myUseIdeaHttpProxyCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 0, false));
        this.passwordLabel = new JPanel();
        this.passwordLabel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPane.add((Component)this.passwordLabel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.passwordLabel.setBorder(BorderFactory.createTitledBorder("Passwords"));
        Spacer spacer2 = new Spacer();
        this.passwordLabel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myResetPasswordsButton = new JButton();
        this.myResetPasswordsButton.setText("Reset Saved Passwords");
        this.myResetPasswordsButton.setMnemonic('R');
        this.myResetPasswordsButton.setDisplayedMnemonicIndex(0);
        this.passwordLabel.add((Component)this.myResetPasswordsButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.checkinPolicyLabel = new JPanel();
        this.checkinPolicyLabel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myContentPane.add((Component)this.checkinPolicyLabel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        this.checkinPolicyLabel.setBorder(BorderFactory.createTitledBorder("Checkin policies compatibility"));
        this.myReportNotInstalledPoliciesCheckBox = new JCheckBox();
        this.myReportNotInstalledPoliciesCheckBox.setText("Warn about not installed policies");
        this.myReportNotInstalledPoliciesCheckBox.setMnemonic('W');
        this.myReportNotInstalledPoliciesCheckBox.setDisplayedMnemonicIndex(0);
        this.checkinPolicyLabel.add((Component)this.myReportNotInstalledPoliciesCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.noteLabel = new JLabel();
        this.noteLabel.setText("(Note: these settings may be overridden for individual team project)");
        this.checkinPolicyLabel.add((Component)this.noteLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTFSCheckBox = new JCheckBox();
        this.myTFSCheckBox.setText("Evaluate Team Explorer policies");
        this.myTFSCheckBox.setMnemonic('T');
        this.myTFSCheckBox.setDisplayedMnemonicIndex(9);
        this.checkinPolicyLabel.add((Component)this.myTFSCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myStatefulCheckBox = new JCheckBox();
        this.myStatefulCheckBox.setText("Evaluate Teamprise policies");
        this.myStatefulCheckBox.setMnemonic('E');
        this.myStatefulCheckBox.setDisplayedMnemonicIndex(10);
        this.checkinPolicyLabel.add((Component)this.myStatefulCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.pathLabel = new JLabel();
        this.pathLabel.setText("Path to tf executable:");
        this.myContentPane.add((Component)this.pathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.tfExeField = new TextFieldWithBrowseButton();
        this.myContentPane.add((Component)this.tfExeField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.testExeButton = new JButton();
        this.testExeButton.setText("Test");
        this.myContentPane.add((Component)this.testExeButton, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 2, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myContentPane.add((Component)spacer3, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

