/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceDialog;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang.StringUtils;

public class WorkspaceController
implements Observer,
ActionListener {
    private final WorkspaceDialog dialog;
    private final WorkspaceModel model;
    private boolean suspendEvents = false;
    private final Project project;

    public WorkspaceController(Project project, ServerContext serverContext) {
        this(project, new WorkspaceDialog(project, serverContext), new WorkspaceModel());
        this.model.loadWorkspace(project);
    }

    public WorkspaceController(Project project, RepositoryContext repositoryContext, ServerContext serverContext, String workspaceName) {
        this(project, new WorkspaceDialog(project, serverContext), new WorkspaceModel());
        this.model.loadWorkspace(repositoryContext, workspaceName);
    }

    protected WorkspaceController(Project project, WorkspaceDialog dialog, WorkspaceModel model) {
        this.project = project;
        this.dialog = dialog;
        this.dialog.addActionListener(this);
        this.model = model;
        this.model.addObserver(this);
        this.setupDialog();
    }

    public boolean showModalDialog(boolean autoSaveWorkspace) {
        boolean result = this.dialog.showModalDialog();
        if (result && autoSaveWorkspace) {
            this.saveWorkspace(this.project.getBasePath(), false, null);
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void saveWorkspace(String workspaceRootPath, boolean syncFiles, Runnable onSuccess) {
        this.updateModel();
        this.model.saveWorkspace(this.project, workspaceRootPath, syncFiles, onSuccess);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.suspendEvents) {
            return;
        }
        if (arg == null || arg.equals("comment")) {
            this.dialog.setComment(this.model.getComment());
        }
        if (arg == null || arg.equals("computer")) {
            this.dialog.setComputer(this.model.getComputer());
        }
        if (arg == null || arg.equals("mappings")) {
            this.dialog.setMappings(this.model.getMappings());
        }
        if (arg == null || arg.equals("name")) {
            this.dialog.setName(this.model.getName());
        }
        if (arg == null || arg.equals("owner")) {
            this.dialog.setOwner(this.model.getOwner());
        }
        if (arg == null || arg.equals("server")) {
            this.dialog.setServer(this.model.getServer());
        }
        if (arg != null && arg.equals("loading")) {
            this.dialog.setLoading(this.model.isLoading());
        }
    }

    private void setupDialog() {
        this.dialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return WorkspaceController.this.validate();
            }
        });
    }

    protected ValidationInfo validate() {
        this.updateModel();
        ModelValidationInfo validationInfo = this.model.validate();
        if (validationInfo != ModelValidationInfo.NO_ERRORS) {
            return new ValidationInfo(validationInfo.getValidationMessage(), this.dialog.getComponent(validationInfo.getValidationSource()));
        }
        String error = this.dialog.getFirstMappingValidationError();
        if (StringUtils.isNotEmpty((String)error)) {
            return new ValidationInfo(error);
        }
        return null;
    }

    protected void updateModel() {
        this.suspendEvents = true;
        try {
            this.model.setComment(this.dialog.getWorkspaceComment());
            this.model.setMappings(this.dialog.getWorkingFolders());
            this.model.setName(this.dialog.getWorkspaceName());
        }
        finally {
            this.suspendEvents = false;
        }
    }

    protected WorkspaceDialog getDialog() {
        return this.dialog;
    }

    protected WorkspaceModel getModel() {
        return this.model;
    }
}

