/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.tfvc.ui.workspace.WorkspaceMappingsTableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WorkspaceForm {
    private JTextField name;
    private JLabel server;
    private JLabel owner;
    private JLabel computer;
    private JTextArea comment;
    private JPanel contentPane;
    private JPanel workingFolderPanel;
    private WorkspaceMappingsTableEditor tableEditor;
    private JLabel workingFoldersLabel;
    private ComboBox location;
    private final Project project;
    private final ServerContext serverContext;
    private final ValidationListener validationListener;

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Name"));
        this.contentPane.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.name = new JTextField();
        this.contentPane.add((Component)this.name, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Server"));
        this.contentPane.add((Component)label2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.server = new JLabel();
        this.server.setText("https://");
        this.contentPane.add((Component)this.server, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Owner"));
        this.contentPane.add((Component)label3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.owner = new JLabel();
        this.owner.setText("domain\\user");
        this.contentPane.add((Component)this.owner, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        this.$$$loadLabelText$$$(label4, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Computer"));
        this.contentPane.add((Component)label4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.computer = new JLabel();
        this.computer.setText("localhost");
        this.contentPane.add((Component)this.computer, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        this.$$$loadLabelText$$$(label5, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Comment"));
        this.contentPane.add((Component)label5, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        this.contentPane.add((Component)jBScrollPane1, new GridConstraints(2, 1, 1, 1, 0, 3, 5, 0, null, null, null, 0, false));
        this.comment = new JTextArea();
        this.comment.setLineWrap(true);
        this.comment.setRows(3);
        this.comment.setText("");
        jBScrollPane1.setViewportView((Component)this.comment);
        this.workingFoldersLabel = new JLabel();
        this.$$$loadLabelText$$$(this.workingFoldersLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.WorkingFolders"));
        this.contentPane.add((Component)this.workingFoldersLabel, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.contentPane.add((Component)spacer1, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null, 0, false));
        JLabel label6 = new JLabel();
        this.$$$loadLabelText$$$(label6, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("WorkspaceDialog.Location"));
        this.contentPane.add((Component)label6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.location = new ComboBox();
        this.location.setEditable(false);
        this.contentPane.add((Component)this.location, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null, 0, false));
        this.contentPane.add((Component)this.workingFolderPanel, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        label1.setLabelFor(this.name);
        label5.setLabelFor(this.comment);
        label6.setLabelFor(this.name);
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private void createUIComponents() {
        String defaultPath = this.project != null ? this.project.getBasePath() : "";
        this.tableEditor = new WorkspaceMappingsTableEditor(this.project, this.serverContext, defaultPath, new WorkspaceMappingsTableEditor.ValidationDispatcher(){

            @Override
            public void showValidationError(String errorMessage) {
                if (WorkspaceForm.this.validationListener != null) {
                    WorkspaceForm.this.validationListener.doValidate();
                }
            }
        });
        this.tableEditor.hideMessageLabel();
        this.tableEditor.setColumnReorderingAllowed(false);
        this.workingFolderPanel = new JPanel(new BorderLayout());
        this.workingFolderPanel.add(this.tableEditor.getContentPane());
    }

    private void setupLocations() {
        this.location.addItem((Object)Location.LOCAL);
        this.location.setEnabled(false);
    }

    public WorkspaceForm(Project project, ServerContext serverContext, ValidationListener validationListener) {
        this.project = project;
        this.serverContext = serverContext;
        this.validationListener = validationListener;
        this.$$$setupUI$$$();
        this.workingFoldersLabel.setLabelFor(this.tableEditor.getPreferredFocusedComponent());
        this.setupLocations();
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setComputer(String computer) {
        this.computer.setText(computer);
    }

    public void setOwner(String owner) {
        this.owner.setText(owner);
    }

    public void setServer(String server) {
        this.server.setText(server);
    }

    public void setWorkspaceName(String name) {
        this.name.setText(name);
    }

    public String getWorkspaceName() {
        return this.name.getText();
    }

    public void setComment(String comment) {
        this.comment.setText(comment);
    }

    public String getComment() {
        return this.comment.getText();
    }

    public void setMappings(List<Workspace.Mapping> mappings) {
        this.tableEditor.setMappings(mappings);
    }

    public List<Workspace.Mapping> getMappings() {
        return this.tableEditor.getMappings();
    }

    public String getFirstMappingValidationError() {
        return this.tableEditor.getFirstValidationError();
    }

    public void setLoading(boolean loading) {
        if (loading) {
            String loadingMessage = TfPluginBundle.message("WorkspaceDialog.Loading", new Object[0]);
            this.name.setEnabled(false);
            this.name.setText(loadingMessage);
            this.comment.setEnabled(false);
            this.comment.setText(loadingMessage);
            this.owner.setEnabled(false);
            this.owner.setText(loadingMessage);
            this.server.setEnabled(false);
            this.server.setText(loadingMessage);
            this.computer.setEnabled(false);
            this.computer.setText(loadingMessage);
        } else {
            this.name.setEnabled(true);
            this.comment.setEnabled(true);
            this.owner.setEnabled(true);
            this.server.setEnabled(true);
            this.computer.setEnabled(true);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.name;
    }

    public JComponent getComponent(String name) {
        if ("name".equals(name)) {
            return this.name;
        }
        if ("comment".equals(name)) {
            return this.comment;
        }
        if ("computer".equals(name)) {
            return this.computer;
        }
        if ("mappings".equals(name)) {
            return this.workingFolderPanel;
        }
        if ("owner".equals(name)) {
            return this.comment;
        }
        if ("server".equals(name)) {
            return this.server;
        }
        return null;
    }

    private static enum Location {
        LOCAL,
        SERVER;

    }
}

