/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.ui.workspace;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.operations.OperationExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.ws.rs.NotAuthorizedException;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceModel
extends AbstractModel {
    private final Logger logger = LoggerFactory.getLogger(WorkspaceModel.class);
    public static final String PROP_NAME = "name";
    public static final String PROP_COMPUTER = "computer";
    public static final String PROP_OWNER = "owner";
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_SERVER = "server";
    public static final String PROP_MAPPINGS = "mappings";
    public static final String PROP_LOADING = "loading";
    private boolean loading;
    private String name;
    private String computer;
    private String owner;
    private String comment;
    private String server;
    private List<Workspace.Mapping> mappings;
    private Workspace oldWorkspace;
    private ServerContext currentServerContext;

    public boolean isLoading() {
        return this.loading;
    }

    @VisibleForTesting
    protected void setLoading(boolean loading) {
        this.loading = loading;
        this.setChangedAndNotify(PROP_LOADING);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals((String)this.name, (String)name)) {
            this.name = name;
            super.setChangedAndNotify(PROP_NAME);
        }
    }

    public String getComputer() {
        return this.computer;
    }

    public void setComputer(String computer) {
        if (!StringUtils.equals((String)this.computer, (String)computer)) {
            this.computer = computer;
            super.setChangedAndNotify(PROP_COMPUTER);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        if (!StringUtils.equals((String)this.owner, (String)owner)) {
            this.owner = owner;
            super.setChangedAndNotify(PROP_OWNER);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (!StringUtils.equals((String)this.comment, (String)comment)) {
            this.comment = comment;
            super.setChangedAndNotify(PROP_COMMENT);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        if (!StringUtils.equals((String)this.server, (String)server)) {
            this.server = server;
            super.setChangedAndNotify(PROP_SERVER);
        }
    }

    public List<Workspace.Mapping> getMappings() {
        if (this.mappings == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mappings);
    }

    public void setMappings(@NotNull List<Workspace.Mapping> mappings) {
        if (WorkspaceHelper.areMappingsDifferent(this.mappings, mappings)) {
            this.mappings = mappings;
            super.setChangedAndNotify(PROP_MAPPINGS);
        }
    }

    public ModelValidationInfo validate() {
        if (StringUtils.isEmpty((String)this.getName())) {
            return ModelValidationInfo.createWithResource(PROP_NAME, "WorkspaceDialog.Errors.NameEmpty", new Object[0]);
        }
        if (this.getMappings().size() == 0) {
            return ModelValidationInfo.createWithResource(PROP_MAPPINGS, "WorkspaceDialog.Errors.MappingsEmpty", new Object[0]);
        }
        return ModelValidationInfo.NO_ERRORS;
    }

    public void loadWorkspace(final Project project) {
        this.logger.info("loadWorkspace starting");
        this.setLoading(true);
        OperationExecutor.getInstance().submitOperationTask(new Runnable(){

            @Override
            public void run() {
                try {
                    WorkspaceModel.this.logger.info("loadWorkspace: getting repository context");
                    RepositoryContext repositoryContext = VcsHelper.getRepositoryContext(project);
                    if (repositoryContext == null || StringUtils.isEmpty((String)repositoryContext.getUrl()) || StringUtils.isEmpty((String)repositoryContext.getTeamProjectName())) {
                        WorkspaceModel.this.logger.warn("loadWorkspace: Could not determine repositoryContext for project");
                        throw new RuntimeException(TfPluginBundle.message("WorkspaceDialog.Errors.ContextFailed", new Object[0]));
                    }
                    WorkspaceModel.this.logger.info("loadWorkspace: getting server context");
                    WorkspaceModel.this.currentServerContext = ServerContextManager.getInstance().createContextFromTfvcServerUrl(repositoryContext.getUrl(), repositoryContext.getTeamProjectName(), true);
                    if (WorkspaceModel.this.currentServerContext == null) {
                        WorkspaceModel.this.logger.warn("loadWorkspace: Could not get the context for the repository. User may have canceled.");
                        throw new NotAuthorizedException((Object)TfPluginBundle.message("WorkspaceDialog.Errors.AuthenticationFailed", repositoryContext.getUrl()), new Object[0]);
                    }
                    WorkspaceModel.this.logger.info("loadWorkspace: getting workspace");
                    WorkspaceModel.this.loadWorkspaceInternal(CommandUtils.getWorkspace((ServerContext)WorkspaceModel.this.currentServerContext, (Project)project));
                }
                finally {
                    WorkspaceModel.this.loadWorkspaceComplete();
                }
            }
        });
    }

    public void loadWorkspace(final RepositoryContext repositoryContext, final String workspaceName) {
        this.logger.info("loadWorkspace starting");
        ArgumentHelper.checkNotNull((Object)repositoryContext, (String)"repositoryContext");
        ArgumentHelper.checkNotEmptyString((String)workspaceName, (String)"workspaceName");
        this.setLoading(true);
        OperationExecutor.getInstance().submitOperationTask(new Runnable(){

            @Override
            public void run() {
                try {
                    WorkspaceModel.this.logger.info("loadWorkspace: getting server context");
                    WorkspaceModel.this.currentServerContext = ServerContextManager.getInstance().createContextFromTfvcServerUrl(repositoryContext.getUrl(), repositoryContext.getTeamProjectName(), true);
                    if (WorkspaceModel.this.currentServerContext == null) {
                        WorkspaceModel.this.logger.warn("loadWorkspace: Could not get the context for the repository. User may have canceled.");
                        throw new NotAuthorizedException((Object)TfPluginBundle.message("WorkspaceDialog.Errors.AuthenticationFailed", repositoryContext.getUrl()), new Object[0]);
                    }
                    WorkspaceModel.this.logger.info("loadWorkspace: getting workspace by name");
                    WorkspaceModel.this.loadWorkspaceInternal(CommandUtils.getWorkspace((ServerContext)WorkspaceModel.this.currentServerContext, (String)workspaceName));
                }
                finally {
                    WorkspaceModel.this.loadWorkspaceComplete();
                }
            }
        });
    }

    private void loadWorkspaceInternal(Workspace workspace) {
        this.oldWorkspace = workspace;
        if (this.oldWorkspace != null) {
            this.logger.info("loadWorkspace: got workspace, setting fields");
            this.server = this.oldWorkspace.getServer();
            this.owner = this.oldWorkspace.getOwner();
            this.computer = this.oldWorkspace.getComputer();
            this.name = this.oldWorkspace.getName();
            this.comment = this.oldWorkspace.getComment();
            this.mappings = new ArrayList<Workspace.Mapping>(this.oldWorkspace.getMappings());
        } else {
            this.logger.warn("loadWorkspace: workspace was returned as null");
        }
    }

    private void loadWorkspaceComplete() {
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                WorkspaceModel.this.setChangedAndNotify(null);
                WorkspaceModel.this.setLoading(false);
                WorkspaceModel.this.logger.info("loadWorkspace: done loading");
            }
        });
    }

    public void saveWorkspace(final Project project, final String workspaceRootPath, final boolean syncFiles, final Runnable onSuccess) {
        final ServerContext serverContext = this.currentServerContext;
        final Workspace oldWorkspace = this.oldWorkspace;
        final Workspace newWorkspace = new Workspace(this.server, this.name, this.computer, this.owner, this.comment, this.mappings);
        Task.Backgroundable backgroundTask = new Task.Backgroundable(project, TfPluginBundle.message("WorkspaceDialog.Progress.Title", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                WorkspaceModel.this.saveWorkspaceInternal(serverContext, oldWorkspace, newWorkspace, indicator, project, workspaceRootPath, syncFiles, onSuccess);
            }
        };
        backgroundTask.queue();
    }

    @VisibleForTesting
    protected void saveWorkspaceInternal(final ServerContext serverContext, Workspace oldWorkspace, Workspace newWorkspace, ProgressIndicator indicator, final Project project, final String workspaceRootPath, boolean syncFiles, Runnable onSuccess) {
        try {
            IdeaHelper.setProgress(indicator, 0.1, TfPluginBundle.message("WorkspaceDialog.Save.Progress.Updating", new Object[0]));
            CommandUtils.updateWorkspace((ServerContext)serverContext, (Workspace)oldWorkspace, (Workspace)newWorkspace);
            if (syncFiles) {
                IdeaHelper.setProgress(indicator, 0.3, TfPluginBundle.message("WorkspaceDialog.Save.Progress.Syncing", new Object[0]));
                CommandUtils.syncWorkspace((ServerContext)serverContext, (String)workspaceRootPath);
            }
            IdeaHelper.setProgress(indicator, 1.0, TfPluginBundle.message("WorkspaceDialog.Save.Progress.Done", new Object[0]), true);
            if (onSuccess != null) {
                IdeaHelper.runOnUIThread(onSuccess, false, ModalityState.defaultModalityState());
            } else {
                VcsNotifier.getInstance((Project)project).notifyImportantInfo(TfPluginBundle.message("WorkspaceDialog.NotifySuccess.Title", new Object[0]), TfPluginBundle.message("WorkspaceDialog.NotifySuccess.Message", new Object[0]), new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent e) {
                        WorkspaceModel.this.syncWorkspaceAsync(serverContext, project, workspaceRootPath);
                    }
                });
            }
        }
        catch (Throwable t) {
            VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("WorkspaceDialog.NotifyFailure.Title", new Object[0]), LocalizationServiceImpl.getInstance().getExceptionMessage(t));
        }
    }

    public void syncWorkspaceAsync(final ServerContext context, final Project project, final String workspaceRootPath) {
        Task.Backgroundable backgroundTask = new Task.Backgroundable(project, TfPluginBundle.message("WorkspaceDialog.Progress.Title", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    IdeaHelper.setProgress(indicator, 0.3, TfPluginBundle.message("WorkspaceDialog.Save.Progress.Syncing", new Object[0]));
                    CommandUtils.syncWorkspace((ServerContext)context, (String)workspaceRootPath);
                    VcsNotifier.getInstance((Project)project).notifySuccess(TfPluginBundle.message("WorkspaceDialog.NotifySuccess.Title", new Object[0]), TfPluginBundle.message("WorkspaceDialog.NotifySuccess.SyncMessage", new Object[0]));
                }
                catch (Throwable t) {
                    VcsNotifier.getInstance((Project)project).notifyError(TfPluginBundle.message("WorkspaceDialog.NotifyFailure.Title", new Object[0]), LocalizationServiceImpl.getInstance().getExceptionMessage(t));
                }
            }
        };
        backgroundTask.queue();
    }
}

