/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudConfiguration
extends CloudConfigurationBase<DockerCloudConfiguration>
implements DockerAgentConfig {
    private static final Logger LOG = Logger.getInstance(DockerCloudConfiguration.class);
    @NonNls
    public static final String DOCKER_HOST_ENV_VAR = "DOCKER_HOST";
    @NonNls
    public static final String DOCKER_TLS_VERIFY_ENV_VAR = "DOCKER_TLS_VERIFY";
    @NonNls
    public static final String DOCKER_CERT_PATH_ENV_VAR = "DOCKER_CERT_PATH";
    @NonNls
    public static final String DOCKER_COMPOSE_EXEC = "docker-compose";
    private String myApiUrl = "";
    private String myCertificatesPath = "";
    private String myDockerComposePath = "docker-compose";
    private String myMachine;
    private List<DockerPathMappingImpl> myPathMappings = DockerCloudConfiguration.createDefaultMappings();
    private boolean myDoNotConnect = false;

    @Nullable
    public static String getDefaultBrowserHost() {
        URL url;
        String urlString = Pieces.reload().getApiUrlAsString();
        if (urlString == null) {
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.debug((Throwable)e);
            try {
                url = new URL("http://" + StringUtil.trimStart((String)urlString, (String)"tcp://"));
            }
            catch (MalformedURLException e2) {
                LOG.debug((Throwable)e2);
                return null;
            }
        }
        return url.getHost();
    }

    public String getApiUrl() {
        return this.myApiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.myApiUrl = apiUrl;
    }

    public String getCertificatesPath() {
        return this.myCertificatesPath;
    }

    public void setCertificatesPath(String certificatesPath) {
        this.myCertificatesPath = certificatesPath;
    }

    public static DockerCloudConfiguration createDefault() {
        String DEFAULT_LINUX_CERT_PATH = "~/.docker";
        String DEFAULT_WIN_NATIVE_URL = "tcp://localhost:2375";
        String DEFAULT_UNIX_SOCK = "unix:///var/run/docker.sock";
        DockerCloudConfiguration result = new DockerCloudConfiguration();
        Pieces pieces = Pieces.reload();
        if (pieces.getApiUrlAsString() != null) {
            result.setApiUrl(pieces.getApiUrlAsString());
        } else {
            String defaultUrl = SystemInfo.isWindows ? "tcp://localhost:2375" : "unix:///var/run/docker.sock";
            result.setApiUrl(defaultUrl);
        }
        String certificatesPath = pieces.getCertificatesPath();
        if (certificatesPath != null) {
            result.setCertificatesPath(FileUtil.toSystemDependentName((String)certificatesPath));
        } else if (SystemInfo.isLinux) {
            result.setCertificatesPath("~/.docker");
        }
        return result;
    }

    private static List<DockerPathMappingImpl> createDefaultMappings() {
        ArrayList<DockerPathMappingImpl> result = new ArrayList<DockerPathMappingImpl>();
        if (SystemInfo.isMac) {
            result.add(DockerPathMappingImpl.createMacDefaults());
        }
        if (SystemInfo.isWindows) {
            result.add(DockerPathMappingImpl.createWinDefaults());
        }
        return result;
    }

    public String getMachine() {
        return this.myMachine;
    }

    public void setMachine(String machine) {
        this.myMachine = machine;
    }

    public boolean isDoNotConnect() {
        return this.myDoNotConnect;
    }

    public String getComposeExecPath() {
        return this.myDockerComposePath;
    }

    public void setComposeExecPath(String dockerComposePath) {
        this.myDockerComposePath = dockerComposePath;
    }

    public void setDoNotConnect(boolean doNotConnect) {
        this.myDoNotConnect = doNotConnect;
    }

    @AbstractCollection
    public List<DockerPathMappingImpl> getPathMappings() {
        return this.myPathMappings;
    }

    public void setPathMappings(List<DockerPathMappingImpl> pathMappings) {
        this.myPathMappings = pathMappings;
    }

    private static class FromDockerOptsFile {
        @NonNls
        private static final String DOCKER_OPTS_FILE_PATH = "/etc/default/docker";
        @NonNls
        private static final String DOCKER_OPTS_INIT_VAR = "DOCKER_OPTS";
        @NonNls
        private static final String TLS_CERT_OPTION = "--tlscert";
        @NonNls
        private static final String HOST_OPTION = "-H";

        private FromDockerOptsFile() {
        }

        public static void load(@NotNull Pieces output) throws IOException {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/docker/DockerCloudConfiguration$FromDockerOptsFile", "load"));
            }
            if (!SystemInfo.isLinux) {
                return;
            }
            String initVarPrefix = "DOCKER_OPTS=";
            for (String line : FileUtil.loadLines((String)DOCKER_OPTS_FILE_PATH)) {
                if (!line.startsWith("DOCKER_OPTS=")) continue;
                FromDockerOptsFile.parseInitVar(StringUtil.trimStart((String)line, (String)"DOCKER_OPTS="), output);
            }
        }

        private static void parseInitVar(String initVar, @NotNull Pieces output) {
            String opt;
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/docker/DockerCloudConfiguration$FromDockerOptsFile", "parseInitVar"));
            }
            Iterator itOpts = ParametersListUtil.parse((String)StringUtil.unquoteString((String)initVar)).iterator();
            String string = opt = itOpts.hasNext() ? (String)itOpts.next() : null;
            while (opt != null) {
                String optValue;
                String nextOpt = itOpts.hasNext() ? (String)itOpts.next() : null;
                int eqIndex = opt.indexOf("=");
                boolean hasEq = eqIndex > -1;
                String optName = hasEq ? opt.substring(0, eqIndex) : opt;
                String string2 = optValue = hasEq ? opt.substring(eqIndex + 1) : nextOpt;
                if (optValue != null) {
                    if (TLS_CERT_OPTION.equals(optName)) {
                        String tlscert = FileUtil.toSystemIndependentName((String)optValue);
                        int filenameIndex = tlscert.lastIndexOf("/");
                        if (filenameIndex > -1) {
                            output.setCertificatesPath(tlscert.substring(0, filenameIndex));
                        }
                    } else if (HOST_OPTION.equals(optName)) {
                        output.setDockerHost(optValue);
                    }
                }
                opt = nextOpt;
            }
        }
    }

    private static class Pieces {
        @NonNls
        private static final String LINUX_HOME_PATH = "~";
        private String myApiUrlString;
        private String myCertificatesPath;

        private Pieces() {
        }

        @Nullable
        public String getApiUrlAsString() {
            return this.myApiUrlString;
        }

        @NotNull
        public static Pieces reload() {
            Pieces result = new Pieces();
            if (SystemInfo.isLinux) {
                try {
                    FromDockerOptsFile.load(result);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            result.loadFromEnvVars();
            Pieces pieces = result;
            if (pieces == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudConfiguration$Pieces", "reload"));
            }
            return pieces;
        }

        public void setDockerHost(@NotNull String dockerHost) {
            if (dockerHost == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerHost", "com/intellij/docker/DockerCloudConfiguration$Pieces", "setDockerHost"));
            }
            this.myApiUrlString = Pieces.replaceAnyHost(dockerHost);
        }

        public void setCertificatesPath(@Nullable String certificatesPath) {
            this.myCertificatesPath = certificatesPath;
        }

        private void loadFromEnvVars() {
            String dockerHost = System.getenv(DockerCloudConfiguration.DOCKER_HOST_ENV_VAR);
            if (dockerHost != null) {
                boolean secured;
                this.setDockerHost(dockerHost);
                boolean bl = secured = System.getenv(DockerCloudConfiguration.DOCKER_TLS_VERIFY_ENV_VAR) != null;
                if (secured) {
                    this.setCertificatesPath(StringUtil.nullize((String)System.getenv(DockerCloudConfiguration.DOCKER_CERT_PATH_ENV_VAR)));
                }
            }
        }

        @Nullable
        public String getCertificatesPath() {
            return Pieces.replaceLinuxHome(this.myCertificatesPath);
        }

        @NotNull
        private static String replaceAnyHost(@NotNull String urlString) {
            if (urlString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/intellij/docker/DockerCloudConfiguration$Pieces", "replaceAnyHost"));
            }
            String LOCAL_HOST = "127.0.0.1";
            String ANY_HOST = "0.0.0.0";
            String string = urlString.contains("0.0.0.0") ? urlString.replace("0.0.0.0", "127.0.0.1") : urlString;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudConfiguration$Pieces", "replaceAnyHost"));
            }
            return string;
        }

        @Nullable
        private static String replaceLinuxHome(@Nullable String path) {
            return path != null && path.startsWith(LINUX_HOME_PATH) ? SystemProperties.getUserHome() + StringUtil.trimStart((String)path, (String)LINUX_HOME_PATH) : path;
        }
    }
}

