/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudConfigurable;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.DockerDeploymentConfigurator;
import com.intellij.docker.DockerDeploymentRuntime;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnectionDataNotAvailableException;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import com.intellij.remoteServer.runtime.deployment.debug.DebuggerLauncher;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebuggerLauncher;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DockerIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCloudType
extends ServerType<DockerCloudConfiguration> {
    public static final String EMPTY_IMAGE_NAME = "<none>:<none>";

    public static DockerCloudType getInstance() {
        return (DockerCloudType)((Object)EP_NAME.findExtension(DockerCloudType.class));
    }

    public DockerCloudType() {
        super("docker");
    }

    @NotNull
    public String getPresentableName() {
        if ("Docker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "getPresentableName"));
        }
        return "Docker";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DockerIcons.Docker;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public DockerCloudConfiguration createDefaultConfiguration() {
        DockerCloudConfiguration dockerCloudConfiguration = DockerCloudConfiguration.createDefault();
        if (dockerCloudConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "createDefaultConfiguration"));
        }
        return dockerCloudConfiguration;
    }

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull DockerCloudConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/DockerCloudType", "createServerConfigurable"));
        }
        DockerCloudConfigurable dockerCloudConfigurable = new DockerCloudConfigurable(configuration);
        if (dockerCloudConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "createServerConfigurable"));
        }
        return dockerCloudConfigurable;
    }

    @NotNull
    public DeploymentConfigurator<?, DockerCloudConfiguration> createDeploymentConfigurator(Project project) {
        DockerDeploymentConfigurator dockerDeploymentConfigurator = new DockerDeploymentConfigurator(project);
        if (dockerDeploymentConfigurator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "createDeploymentConfigurator"));
        }
        return dockerDeploymentConfigurator;
    }

    @NotNull
    public ServerConnector<?> createConnector(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/DockerCloudType", "createConnector"));
        }
        if (asyncTasksExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncTasksExecutor", "com/intellij/docker/DockerCloudType", "createConnector"));
        }
        DockerConnector dockerConnector = new DockerConnector(configuration, asyncTasksExecutor);
        if (dockerConnector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "createConnector"));
        }
        return dockerConnector;
    }

    @NotNull
    public Comparator<Deployment> getDeploymentComparator() {
        Comparator comparator = (o1, o2) -> {
            DockerApplicationRuntime runtime1 = (DockerApplicationRuntime)o1.getRuntime();
            DockerApplicationRuntime runtime2 = (DockerApplicationRuntime)o2.getRuntime();
            if (runtime1 == null || runtime2 == null) {
                if (runtime1 == null && runtime2 == null) {
                    return super.getDeploymentComparator().compare(o1, o2);
                }
                return runtime1 == null ? 1 : -1;
            }
            String containerId1 = runtime1.getContainerId();
            String containerId2 = runtime2.getContainerId();
            if (containerId1 == null || containerId2 == null) {
                if (containerId1 == null && containerId2 == null) {
                    return this.compareImages((Deployment)o1, (Deployment)o2);
                }
                return containerId1 == null ? 1 : -1;
            }
            String containerName1 = runtime1.getContainerName();
            String containerName2 = runtime2.getContainerName();
            if (containerName1 == null || containerName2 == null) {
                if (containerName1 == null && containerName2 == null) {
                    return StringUtil.compare((String)containerId1, (String)containerId2, (boolean)false);
                }
                return containerName1 == null ? 1 : -1;
            }
            return StringUtil.compare((String)containerName1, (String)containerName2, (boolean)false);
        };
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType", "getDeploymentComparator"));
        }
        return comparator;
    }

    private int compareImages(Deployment o1, Deployment o2) {
        boolean noImageTags2;
        DockerApplicationRuntime runtime1 = (DockerApplicationRuntime)o1.getRuntime();
        DockerApplicationRuntime runtime2 = (DockerApplicationRuntime)o2.getRuntime();
        String imageId1 = runtime1.getImageId();
        String imageId2 = runtime2.getImageId();
        if (imageId1 == null || imageId2 == null) {
            if (imageId1 == null && imageId2 == null) {
                return super.getDeploymentComparator().compare(o1, o2);
            }
            return imageId1 == null ? 1 : -1;
        }
        ArrayList imageTags1 = new ArrayList(ContainerUtil.notNullize(runtime1.getImageRepoTags()));
        ArrayList imageTags2 = new ArrayList(ContainerUtil.notNullize(runtime2.getImageRepoTags()));
        Collections.sort(imageTags1);
        Collections.sort(imageTags2);
        String firstTag1 = (String)ContainerUtil.getFirstItem(imageTags1);
        String firstTag2 = (String)ContainerUtil.getFirstItem(imageTags2);
        boolean noImageTags1 = firstTag1 == null || StringUtil.equals((CharSequence)firstTag1, (CharSequence)EMPTY_IMAGE_NAME);
        boolean bl = noImageTags2 = firstTag2 == null || StringUtil.equals((CharSequence)firstTag2, (CharSequence)EMPTY_IMAGE_NAME);
        if (noImageTags1 || noImageTags2) {
            if (noImageTags1 && noImageTags2) {
                return StringUtil.compare((String)imageId1, (String)imageId2, (boolean)false);
            }
            return noImageTags1 ? 1 : -1;
        }
        return StringUtil.compare((String)firstTag1, (String)firstTag2, (boolean)false);
    }

    public boolean isDebugSupported() {
        return PlatformUtils.isIntelliJ();
    }

    @Nullable
    public DebugConnector<?, ?> createDebugConnector() {
        if (!this.isDebugSupported()) {
            return null;
        }
        return new DebugConnector<JavaDebugConnectionData, DockerDeploymentRuntime>(){

            @NotNull
            public DebuggerLauncher<JavaDebugConnectionData> getLauncher() {
                JavaDebuggerLauncher javaDebuggerLauncher = JavaDebuggerLauncher.getInstance();
                if (javaDebuggerLauncher == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType$1", "getLauncher"));
                }
                return javaDebuggerLauncher;
            }

            @NotNull
            public JavaDebugConnectionData getConnectionData(@NotNull DockerDeploymentRuntime runtime) throws DebugConnectionDataNotAvailableException {
                JavaDebugConnectionData javaDebugConnectionData;
                if (runtime == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "com/intellij/docker/DockerCloudType$1", "getConnectionData"));
                }
                try {
                    javaDebugConnectionData = runtime.getDebugConnectionData();
                }
                catch (ServerRuntimeException e) {
                    throw new DebugConnectionDataNotAvailableException(e.getMessage(), (Throwable)e);
                }
                if (javaDebugConnectionData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerCloudType$1", "getConnectionData"));
                }
                return javaDebugConnectionData;
            }
        };
    }

    @Nullable
    public String getCustomToolWindowId() {
        return "Docker";
    }
}

