/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSource;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeDeploymentRuntime
extends DockerApplicationRuntime {
    private static final String NOT_SUPPORTED_COMMAND_OUTPUT = "No such command";
    private final DockerAgent myAgent;
    private final DeploymentLogManager myLogManager;
    private final DockerCloudConfiguration myServerConfiguration;
    private final File myComposeFile;
    private List<DockerAgentApplication> myAgentApplications = new ArrayList<DockerAgentApplication>();
    private List<ServiceRuntime> myServiceRuntimes = new ArrayList<ServiceRuntime>();
    private boolean myHasErrors = false;

    public DockerComposeDeploymentRuntime(DockerAgent agent, DeploymentTask<DockerDeploymentConfiguration> task, DeploymentLogManager logManager, ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, DockerCloudConfiguration serverConfiguration) throws ServerRuntimeException {
        super(taskExecutor, agentTaskExecutor, task.getSource().getPresentableName(), null);
        this.myAgent = agent;
        this.myLogManager = logManager;
        this.myServerConfiguration = serverConfiguration;
        DockerComposeDeploymentSource source = (DockerComposeDeploymentSource)task.getSource();
        this.myComposeFile = source.getFile();
        if (this.myComposeFile == null) {
            throw new ServerRuntimeException("Docker Compose file not found");
        }
    }

    public void deploy(ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.listServicesStep(callback);
    }

    private void listServicesStep(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        final DeploymentRuntime.UndeploymentTaskCallback undeployCallback = new DeploymentRuntime.UndeploymentTaskCallback(){

            public void succeeded() {
                DockerComposeDeploymentRuntime.this.rebuildStep(callback);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/DockerComposeDeploymentRuntime$1", "errorOccurred"));
                }
                callback.errorOccurred(errorMessage);
            }
        };
        GeneralCommandLine commandLine = this.createCommandLine();
        commandLine.addParameter("config");
        commandLine.addParameter("--service");
        try {
            OSProcessHandler configProcessHandler = new OSProcessHandler(commandLine);
            configProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
                private boolean myConfigCommandSupported = true;

                public void processTerminated(ProcessEvent event) {
                    if (!this.myConfigCommandSupported) {
                        try {
                            List services = (List)DockerComposeDeploymentRuntime.this.getAgentTaskExecutor().execute(() -> Arrays.asList(DockerComposeDeploymentRuntime.this.myAgent.getComposeServices(DockerComposeDeploymentRuntime.this.myComposeFile)));
                            this.collectServices(services);
                        }
                        catch (ServerRuntimeException e) {
                            callback.errorOccurred(e.getMessage());
                            return;
                        }
                    }
                    DockerComposeDeploymentRuntime.this.downStep(undeployCallback);
                }

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (StringUtil.contains((CharSequence)event.getText(), (CharSequence)DockerComposeDeploymentRuntime.NOT_SUPPORTED_COMMAND_OUTPUT)) {
                        this.myConfigCommandSupported = false;
                    } else if (outputType == ProcessOutputTypes.STDOUT) {
                        this.collectServices(Arrays.asList(event.getText().split("\n")));
                    }
                }

                private void collectServices(List<String> serviceNames) {
                    ContainerUtil.addAll((Collection)DockerComposeDeploymentRuntime.this.myServiceRuntimes, (Iterable)ContainerUtil.map(serviceNames, s -> new ServiceRuntime(DockerComposeDeploymentRuntime.this.getTaskExecutor(), DockerComposeDeploymentRuntime.this.getAgentTaskExecutor(), (String)s)));
                }
            });
            configProcessHandler.startNotify();
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    private void downStep(final DeploymentRuntime.UndeploymentTaskCallback callback) {
        try {
            this.myLogManager.getMainLoggingHandler().print("Removing old containers...\n");
            GeneralCommandLine downCommandLine = this.createCommandLine();
            downCommandLine.addParameter("down");
            OSProcessHandler downProcessHandler = new OSProcessHandler(downCommandLine);
            downProcessHandler.addProcessListener((ProcessListener)new PrintingProcessListener(){
                private boolean myDownCommandSupported = true;

                public void processTerminated(ProcessEvent event) {
                    if (!this.myDownCommandSupported) {
                        DockerComposeDeploymentRuntime.this.stopServicesStep(callback);
                    } else {
                        callback.succeeded();
                    }
                }

                @Override
                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (StringUtil.contains((CharSequence)event.getText(), (CharSequence)DockerComposeDeploymentRuntime.NOT_SUPPORTED_COMMAND_OUTPUT)) {
                        this.myDownCommandSupported = false;
                    } else if (this.myDownCommandSupported) {
                        super.onTextAvailable(event, outputType);
                    }
                }
            });
            downProcessHandler.startNotify();
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    private void rebuildStep(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        GeneralCommandLine commandLine = this.createCommandLine();
        commandLine.addParameter("build");
        this.myLogManager.getMainLoggingHandler().print("(Re)building services...\n");
        try {
            OSProcessHandler composeBuildProcessHandler = new OSProcessHandler(commandLine);
            composeBuildProcessHandler.addProcessListener((ProcessListener)new PrintingProcessListener(){

                public void processTerminated(ProcessEvent event) {
                    DockerComposeDeploymentRuntime.this.upStep(callback);
                }
            });
            composeBuildProcessHandler.startNotify();
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    private void upStep(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        GeneralCommandLine commandLine = this.createCommandLine();
        commandLine.addParameter("up");
        commandLine.addParameter("-d");
        this.myLogManager.getMainLoggingHandler().print("Starting...\n");
        try {
            OSProcessHandler composeUpProcessHandler = new OSProcessHandler(commandLine);
            composeUpProcessHandler.addProcessListener((ProcessListener)new PrintingProcessListener(){

                public void processTerminated(ProcessEvent event) {
                    try {
                        DockerComposeDeploymentRuntime.this.getAgentTaskExecutor().execute(() -> {
                            ContainerUtil.addAll((Collection)DockerComposeDeploymentRuntime.this.myAgentApplications, (Object[])DockerComposeDeploymentRuntime.this.myAgent.getApplications());
                            return null;
                        });
                        DockerComposeDeploymentRuntime.this.checkDeploy(callback);
                    }
                    catch (ServerRuntimeException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                }
            });
            composeUpProcessHandler.startNotify();
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    private void stopServicesStep(final DeploymentRuntime.UndeploymentTaskCallback callback) {
        final AtomicInteger stoppedCount = new AtomicInteger(0);
        try {
            for (ServiceRuntime composeService : this.myServiceRuntimes) {
                GeneralCommandLine commandLine = this.createCommandLine();
                commandLine.addParameter("stop");
                commandLine.addParameter(composeService.getServiceName());
                OSProcessHandler composeStopProcessHandler = new OSProcessHandler(commandLine);
                composeStopProcessHandler.addProcessListener((ProcessListener)new PrintingProcessListener(){

                    public void processTerminated(ProcessEvent event) {
                        if (stoppedCount.incrementAndGet() == DockerComposeDeploymentRuntime.this.myServiceRuntimes.size()) {
                            DockerComposeDeploymentRuntime.this.removeServicesStep(callback);
                        }
                    }
                });
                composeStopProcessHandler.startNotify();
            }
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    private void removeServicesStep(final DeploymentRuntime.UndeploymentTaskCallback callback) {
        final AtomicInteger removedCount = new AtomicInteger(0);
        try {
            for (ServiceRuntime composeService : this.myServiceRuntimes) {
                GeneralCommandLine commandLine = this.createCommandLine();
                commandLine.addParameter("rm");
                commandLine.addParameter("-f");
                commandLine.addParameter(composeService.getServiceName());
                OSProcessHandler removeContainerProcessHandler = new OSProcessHandler(commandLine);
                removeContainerProcessHandler.addProcessListener((ProcessListener)new PrintingProcessListener(){

                    public void processTerminated(ProcessEvent event) {
                        if (removedCount.incrementAndGet() == DockerComposeDeploymentRuntime.this.myServiceRuntimes.size()) {
                            callback.succeeded();
                        }
                    }
                });
                removeContainerProcessHandler.startNotify();
            }
        }
        catch (ExecutionException e) {
            callback.errorOccurred(e.getMessage());
        }
    }

    @NotNull
    private GeneralCommandLine createCommandLine() {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(this.myComposeFile.getParentFile());
        commandLine.withEnvironment("DOCKER_HOST", this.myServerConfiguration.getApiUrl());
        String certificatesPath = this.myServerConfiguration.getCertificatesPath();
        if (!StringUtil.isEmpty((String)certificatesPath)) {
            commandLine.withEnvironment("DOCKER_CERT_PATH", certificatesPath);
            commandLine.withEnvironment("DOCKER_TLS_VERIFY", "1");
        }
        commandLine.setExePath(this.myServerConfiguration.getComposeExecPath());
        commandLine.addParameter("-f");
        commandLine.addParameter(this.myComposeFile.getAbsolutePath());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerComposeDeploymentRuntime", "createCommandLine"));
        }
        return generalCommandLine;
    }

    private void checkDeploy(ServerRuntimeInstance.DeploymentOperationCallback callback) throws ExecutionException {
        this.pollServiceContainers(new CollectingContainerIdsDeploymentCallback(callback));
    }

    public void pollServiceContainers(CollectingContainerIdsCallback callback) throws ExecutionException {
        if (this.myServiceRuntimes.isEmpty()) {
            callback.allServicesProcessed();
            return;
        }
        AtomicInteger checkedServicesCount = new AtomicInteger(0);
        for (ServiceRuntime serviceRuntime : this.myServiceRuntimes) {
            String service = serviceRuntime.getServiceName();
            GeneralCommandLine commandLine = this.createCommandLine();
            commandLine.addParameter("ps");
            commandLine.addParameter("-q");
            commandLine.addParameter(service);
            OSProcessHandler composePsProcessHandler = new OSProcessHandler(commandLine);
            composePsProcessHandler.addProcessListener((ProcessListener)new CollectingContainerIdsProcessListener(checkedServicesCount, serviceRuntime, callback));
            composePsProcessHandler.startNotify();
        }
    }

    private void finish(ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (this.myHasErrors) {
            callback.errorOccurred("Some services/containers not started");
        } else {
            callback.succeeded((DeploymentRuntime)this);
        }
    }

    public List<ServiceRuntime> getServiceRuntimes() {
        return this.myServiceRuntimes;
    }

    @Override
    public boolean isUndeploySupported() {
        return true;
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/DockerComposeDeploymentRuntime", "undeploy"));
        }
        this.downStep(callback);
    }

    private class PrintingProcessListener
    extends ProcessAdapter {
        private PrintingProcessListener() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
                DockerComposeDeploymentRuntime.this.myLogManager.getMainLoggingHandler().print(event.getText().replaceAll("\\[\\dB", ""));
            }
        }
    }

    public class ServiceRuntime
    extends DockerApplicationRuntime {
        private final DeploymentStatus myStatus;
        private final String myServiceName;
        private List<String> myContainerIds;

        public ServiceRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String serviceName) {
            super(taskExecutor, agentTaskExecutor, DockerComposeDeploymentRuntime.this.getApplicationName() + ":" + serviceName, DockerComposeDeploymentRuntime.this);
            this.myContainerIds = new ArrayList<String>();
            this.myServiceName = serviceName;
            this.myStatus = new DeploymentStatus(DockerCloudType.getInstance().getIcon(), serviceName, false);
        }

        public void scaleService(String scaleNumber) {
            GeneralCommandLine commandLine = DockerComposeDeploymentRuntime.this.createCommandLine();
            commandLine.setExePath(commandLine.getExePath());
            commandLine.addParameter("scale");
            commandLine.addParameter(this.myServiceName + "=" + scaleNumber);
            try {
                OSProcessHandler scaleProcessHandler = new OSProcessHandler(commandLine);
                scaleProcessHandler.startNotify();
            }
            catch (ExecutionException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        }

        public void startService() {
            this.doStartStopService("start");
        }

        public void stopService() {
            this.doStartStopService("stop");
        }

        private void doStartStopService(String command) {
            GeneralCommandLine commandLine = DockerComposeDeploymentRuntime.this.createCommandLine();
            commandLine.addParameter(command);
            commandLine.addParameter(this.getServiceName());
            try {
                OSProcessHandler startProcessHandler = new OSProcessHandler(commandLine);
                DockerComposeDeploymentRuntime.this.myLogManager.getMainLoggingHandler().attachToProcess((ProcessHandler)startProcessHandler);
                startProcessHandler.startNotify();
            }
            catch (ExecutionException e) {
                this.getCloudNotifier().showMessage(e.getMessage(), MessageType.ERROR);
            }
        }

        @Override
        @Nullable
        public DeploymentStatus getStatus() {
            return this.myStatus;
        }

        public void addContainerIds(List<String> containerIds) {
            this.myContainerIds.addAll(containerIds);
        }

        public List<String> getContainerIds() {
            return this.myContainerIds;
        }

        public String getServiceName() {
            return this.myServiceName;
        }
    }

    public static interface CollectingContainerIdsCallback {
        public void checkServiceContainerIds(ServiceRuntime var1);

        public void allServicesProcessed();
    }

    private class CollectingContainerIdsProcessListener
    extends ProcessAdapter {
        private final AtomicInteger myCheckedServicesCount;
        private final ServiceRuntime myServiceRuntime;
        private final CollectingContainerIdsCallback myCallback;
        private List<String> myContainersId = new ArrayList<String>();

        public CollectingContainerIdsProcessListener(AtomicInteger checkedServicesCount, ServiceRuntime service, CollectingContainerIdsCallback callback) {
            this.myCheckedServicesCount = checkedServicesCount;
            this.myServiceRuntime = service;
            this.myCallback = callback;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                ContainerUtil.addAll(this.myContainersId, (Object[])event.getText().split("\n"));
            }
        }

        public void processTerminated(ProcessEvent event) {
            this.myServiceRuntime.addContainerIds(this.myContainersId);
            this.myCallback.checkServiceContainerIds(this.myServiceRuntime);
            if (this.myCheckedServicesCount.incrementAndGet() == DockerComposeDeploymentRuntime.this.myServiceRuntimes.size()) {
                this.myCallback.allServicesProcessed();
            }
        }
    }

    private class CollectingContainerIdsDeploymentCallback
    implements CollectingContainerIdsCallback {
        private ServerRuntimeInstance.DeploymentOperationCallback myCallback;

        private CollectingContainerIdsDeploymentCallback(ServerRuntimeInstance.DeploymentOperationCallback callback) {
            this.myCallback = callback;
        }

        @Override
        public void checkServiceContainerIds(ServiceRuntime runtime) {
            List<String> containerIds = runtime.getContainerIds();
            if (containerIds.isEmpty()) {
                DockerComposeDeploymentRuntime.this.myHasErrors = true;
                DockerComposeDeploymentRuntime.this.myLogManager.getMainLoggingHandler().print("No containers created for service: " + runtime.getServiceName() + "\n");
            }
            for (String composeContainerId : containerIds) {
                this.checkContainerForErrors(composeContainerId);
            }
        }

        private void checkContainerForErrors(String containerId) {
            for (DockerAgentApplication application : DockerComposeDeploymentRuntime.this.myAgentApplications) {
                if (!StringUtil.equals((CharSequence)StringUtil.trim((String)containerId), (CharSequence)application.getContainerId()) || StringUtil.startsWith((CharSequence)application.getContainerStatus(), (CharSequence)"Up")) continue;
                DockerComposeDeploymentRuntime.this.myLogManager.getMainLoggingHandler().print("Container [Name:" + application.getContainerName() + "; ID:" + containerId + "]: is not started\n");
                DockerComposeDeploymentRuntime.this.myHasErrors = true;
            }
        }

        @Override
        public void allServicesProcessed() {
            DockerComposeDeploymentRuntime.this.finish(this.myCallback);
        }
    }
}

