/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerClientLibraryLoader;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerConnector
extends ServerConnector<DockerDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(DockerConnector.class);
    public static final ClientLibraryDescription Docker = new ClientLibraryDescription("docker-2.5.0", DockerConnector.class.getResource("/resources/DockerClientLib.xml"));
    private final DockerCloudConfiguration myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public DockerConnector(DockerCloudConfiguration configuration, ServerTaskExecutor tasksExecutor) {
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(@NotNull ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/DockerConnector", "connect"));
        }
        this.myTasksExecutor.submit(() -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/DockerConnector", "lambda$connect$0"));
            }
            List clientLibrary = DockerConnector.loadClientLibraryFromExtensions();
            if (clientLibrary == null) {
                try {
                    clientLibrary = ClientLibraryManager.getInstance().download(Docker);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                    return;
                }
            }
            new DockerServerRuntimeInstance(this.myConfiguration, this.myTasksExecutor, clientLibrary).connect(callback);
        }, callback);
    }

    @Nullable
    public static List<File> loadClientLibraryFromExtensions() {
        DockerClientLibraryLoader[] extensions;
        for (DockerClientLibraryLoader extension : extensions = (DockerClientLibraryLoader[])DockerClientLibraryLoader.EP_NAME.getExtensions()) {
            LOG.debug("Loading client library using " + extension);
            List<File> clientLibrary = extension.loadLibrary();
            if (clientLibrary != null) {
                LOG.debug("Client library loaded using " + extension);
                return clientLibrary;
            }
            LOG.info("Unable to load client library using " + extension);
        }
        return null;
    }
}

