/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentEditor;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSource;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSource;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentConfigurator
extends CloudDeploymentConfiguratorBase<DockerDeploymentConfiguration, DockerCloudConfiguration> {
    private final Project myProject;

    public DockerDeploymentConfigurator(Project project) {
        super(project, (ServerType)DockerCloudType.getInstance());
        this.myProject = project;
    }

    @NotNull
    public DockerDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/DockerDeploymentConfigurator", "createDefaultConfiguration"));
        }
        DockerDeploymentConfiguration dockerDeploymentConfiguration = new DockerDeploymentConfiguration();
        if (dockerDeploymentConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerDeploymentConfigurator", "createDefaultConfiguration"));
        }
        return dockerDeploymentConfiguration;
    }

    public SettingsEditor<DockerDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @NotNull RemoteServer<DockerCloudConfiguration> server) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/DockerDeploymentConfigurator", "createEditor"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/docker/DockerDeploymentConfigurator", "createEditor"));
        }
        return source instanceof DockerComposeDeploymentSource ? null : new DockerDeploymentEditor(this.myProject, source instanceof DockerImageDeploymentSource);
    }
}

