/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.docker.ConfigurationHelpAreaWrapper;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.browsers.StartBrowserPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentEditor
extends SettingsEditor<DockerDeploymentConfiguration> {
    private final Project myProject;
    private JPanel myMainPanel;
    private JBLabel myImageLabel;
    private JTextField myImageTextField;
    private JTextField myContainerNameTextField;
    private JPanel myStartBrowserPanelPlaceHolder;
    private JTextField myDebugPortTextField;
    private JBLabel myDebugPortLabel;
    private JPanel myHelpAreaPanelPlaceHolder;
    private final StartBrowserPanel myStartBrowserPanel;
    private ConfigurationHelpAreaWrapper myHelpAreaWrapper;
    private GenericDebuggerRunnerSettings myDebuggerSettings;

    public DockerDeploymentEditor(Project project, boolean imageNotFileSource) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myImageLabel.setText(imageNotFileSource ? "Image ID:" : "Image tag:");
        this.myStartBrowserPanel = new StartBrowserPanel();
        this.myStartBrowserPanelPlaceHolder.add(this.myStartBrowserPanel.getComponent());
        boolean debugSupported = DockerCloudType.getInstance().isDebugSupported();
        this.myDebugPortLabel.setVisible(debugSupported);
        this.myDebugPortTextField.setVisible(debugSupported);
        this.myHelpAreaPanelPlaceHolder.setVisible(debugSupported);
        if (debugSupported) {
            this.myHelpAreaWrapper = new ConfigurationHelpAreaWrapper();
            this.myHelpAreaPanelPlaceHolder.add(this.myHelpAreaWrapper.getPanel());
            this.myDebuggerSettings = new GenericDebuggerRunnerSettings();
            this.myDebuggerSettings.setLocal(false);
            this.myDebugPortTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    DockerDeploymentEditor.this.updateHelpArea();
                }
            });
            this.updateHelpArea();
        }
    }

    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/DockerDeploymentEditor", "resetEditorFrom"));
        }
        Integer debugPort = configuration.getDebugPort();
        String debugPortText = debugPort != null ? String.valueOf(debugPort) : "";
        this.myImageTextField.setText(configuration.getImageTag());
        this.myContainerNameTextField.setText(configuration.getContainerName());
        this.myStartBrowserPanel.setFromSettings(configuration.getStartBrowserSettings());
        this.myDebugPortTextField.setText(debugPortText);
    }

    private void updateHelpArea() {
        String debugPort = this.myDebugPortTextField.getText();
        boolean hasDebugPort = StringUtil.isNotEmpty((String)debugPort);
        this.myHelpAreaWrapper.getPanel().setVisible(hasDebugPort);
        if (hasDebugPort) {
            DockerDeploymentConfiguration configuration = new DockerDeploymentConfiguration();
            try {
                this.applyEditorTo(configuration);
                String remoteDebugPort = configuration.getRemoteDebugPort(this.myProject);
                if (remoteDebugPort != null) {
                    debugPort = remoteDebugPort;
                }
            }
            catch (ConfigurationException remoteDebugPort) {
                // empty catch block
            }
            this.myDebuggerSettings.setDebugPort(debugPort);
            JavaParameters javaParameters = new JavaParameters();
            Sdk projectSdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
            if (projectSdk != null && projectSdk.getSdkType() instanceof JavaSdkType) {
                javaParameters.setJdk(projectSdk);
            }
            try {
                DebuggerManagerImpl.createDebugParameters((JavaParameters)javaParameters, (GenericDebuggerRunnerSettings)this.myDebuggerSettings, (boolean)false);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            this.myHelpAreaWrapper.updateText(javaParameters.getVMParametersList().getParametersString());
        }
    }

    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/DockerDeploymentEditor", "applyEditorTo"));
        }
        configuration.setImageTag(this.myImageTextField.getText());
        configuration.setContainerName(this.myContainerNameTextField.getText());
        configuration.setStartBrowserSettings(this.myStartBrowserPanel.createSettings());
        configuration.setDebugPort(DockerDeploymentEditor.parsePort(this.myDebugPortTextField.getText()));
    }

    private static Integer parsePort(String portText) throws RuntimeConfigurationException {
        if (StringUtil.isEmpty((String)portText)) {
            return null;
        }
        try {
            return Integer.parseInt(portText);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException("Invalid port number");
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerDeploymentEditor", "createEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JTextField jTextField;
        JBLabel jBLabel;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JTextField jTextField2;
        JTextField jTextField3;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myImageTextField = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myContainerNameTextField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myImageLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Image tag:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Container name:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myStartBrowserPanelPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDebugPortLabel = jBLabel = new JBLabel();
        jBLabel.setText("Debug port:");
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebugPortTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myHelpAreaPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jBLabel2.setLabelFor(jTextField3);
        jBLabel3.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

