/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSource;
import com.intellij.docker.deploymentSource.DockerfileDeploymentSource;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudLoggingHandlerImpl;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class DockerDeploymentRuntime
extends DockerApplicationRuntime {
    private final DockerAgentDeployment myAgentDeployment;
    private final DeploymentTask<DockerDeploymentConfiguration> myTask;
    private final DockerCloudConfiguration myServerConfiguration;
    private boolean myOutdated = false;

    public DockerDeploymentRuntime(DockerAgent agent, DeploymentTask<DockerDeploymentConfiguration> task, DeploymentLogManager logManager, ServerTaskExecutor serverTaskExecutor, AgentTaskExecutor agentTaskExecutor, DockerCloudConfiguration serverConfiguration, DockerApplicationRuntime containersGroup) throws ServerRuntimeException {
        super(serverTaskExecutor, agentTaskExecutor, task.getSource().getPresentableName(), containersGroup);
        File sourceFile;
        DockerAgentSourceType sourceType;
        this.myTask = task;
        this.myServerConfiguration = serverConfiguration;
        DeploymentSource source = task.getSource();
        if (source instanceof DockerfileDeploymentSource) {
            sourceType = DockerAgentSourceType.FILE;
            File dockerFile = source.getFile();
            if (dockerFile == null) {
                throw new ServerRuntimeException("Dockerfile not specified");
            }
            sourceFile = dockerFile;
        } else if (source instanceof DockerImageDeploymentSource) {
            sourceType = DockerAgentSourceType.IMAGE;
            sourceFile = null;
        } else {
            sourceType = DockerAgentSourceType.FILE;
            sourceFile = source.getFile();
            if (sourceFile == null) {
                throw new ServerRuntimeException("Artifact file not found");
            }
        }
        final DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)task.getConfiguration();
        final String jsonFilePath = StringUtil.nullize((String)configuration.getSystemDependentJSONFilePath());
        this.myAgentDeployment = agent.createDeployment(new DockerAgentDeploymentConfig(){

            public String getDeploymentName() {
                return null;
            }

            public File getFile() {
                return sourceFile;
            }

            public String getImageTag() {
                return configuration.getImageTag();
            }

            public String getContainerName() {
                return configuration.getContainerName();
            }

            public String getJSON() {
                return jsonFilePath;
            }

            public String sourceType() {
                return sourceType.name();
            }

            public boolean isCreateContainerOnly() {
                return false;
            }

            public boolean isBuildImageOnly() {
                return false;
            }

            public boolean isFileArchive() {
                return false;
            }

            public String getUser() {
                return null;
            }

            public DockerLabel[] getLabels() {
                return null;
            }

            public String[] getEntrypoint() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getEntrypoint());
            }

            public String[] getCommand() {
                return DockerDeploymentRuntime.parseCommandLine(configuration.getCommand());
            }

            public DockerVolumesFrom[] getVolumesFrom() {
                return null;
            }

            public String getNetworkMode() {
                return null;
            }

            public String[] getExtraHosts() {
                return null;
            }

            public String getWorkingDir() {
                return null;
            }

            public Boolean getNetworkDisabled() {
                return null;
            }

            public DockerPortBinding[] getPortBindings() {
                List<DockerPortBindingImpl> portBindings = configuration.getPortBindings();
                return portBindings.isEmpty() ? null : portBindings.toArray(new DockerPortBinding[portBindings.size()]);
            }

            public Boolean getPublishAllPorts() {
                return this.isPublishAllPorts();
            }

            public boolean isPublishAllPorts() {
                return configuration.isPublishAllPorts();
            }

            public Integer[] getExposedPorts() {
                return null;
            }

            public DockerLink[] getLinks() {
                List<DockerLinkImpl> links = configuration.getLinks();
                return links.isEmpty() ? null : links.toArray(new DockerLink[links.size()]);
            }

            public DockerVolumeBinding[] getVolumeBindings() {
                List<DockerVolumeBindingImpl> binds = configuration.getVolumeBindings();
                return binds.isEmpty() ? null : binds.toArray(new DockerVolumeBinding[binds.size()]);
            }

            public DockerEnvVar[] getEnvVars() {
                List<DockerEnvVarImpl> envVars = configuration.getEnvVars();
                return envVars.isEmpty() ? null : envVars.toArray(new DockerEnvVar[envVars.size()]);
            }
        }, (CloudAgentLoggingHandler)new CloudLoggingHandlerImpl(logManager), (DockerAgentPathMapper)new DockerAgentPathMapperImpl(this.myTask.getProject()));
    }

    private static String[] parseCommandLine(String commandLine) {
        return StringUtil.isEmpty((String)commandLine) ? null : ParametersListUtil.parseToArray((String)commandLine);
    }

    public DockerDeploymentConfiguration getConfiguration() {
        return (DockerDeploymentConfiguration)this.myTask.getConfiguration();
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.getAgentTaskExecutor().execute(() -> {
            this.myAgentDeployment.deploy();
            return null;
        }, (CallbackWrapper)new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                DockerDeploymentRuntime.this.setApplication((DockerAgentApplication)DockerDeploymentRuntime.this.myAgentDeployment);
                Deployment deployment = callback.succeeded((DeploymentRuntime)DockerDeploymentRuntime.this);
                DockerDeploymentRuntime.this.setDeploymentModel(deployment);
                DockerDeploymentRuntime.this.openBrowser(DockerDeploymentRuntime.this.getConfiguration().getStartBrowserSettings());
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public void setOutdated() {
        this.myOutdated = true;
    }

    public void openBrowser() {
        StartBrowserSettings settings = new StartBrowserSettings();
        StartBrowserSettings defaultSettings = this.getConfiguration().getStartBrowserSettings();
        settings.setSelected(true);
        settings.setBrowser(defaultSettings.getBrowser());
        settings.setUrl(defaultSettings.getUrl());
        settings.setStartJavaScriptDebugger(defaultSettings.isStartJavaScriptDebugger());
        this.openBrowser(settings);
    }

    private void openBrowser(StartBrowserSettings startBrowserSettings) {
        RunnerAndConfigurationSettings runConfigSettings = this.myTask.getExecutionEnvironment().getRunnerAndConfigurationSettings();
        if (runConfigSettings == null) {
            return;
        }
        new BrowserStarter(runConfigSettings.getConfiguration(), startBrowserSettings, () -> this.myOutdated).start();
    }

    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        URL apiUrl;
        Integer debugPort = ((DockerDeploymentConfiguration)this.myTask.getConfiguration()).getDebugPort();
        if (debugPort == null) {
            throw new ServerRuntimeException("Debug port not specified");
        }
        try {
            apiUrl = new URL(this.myServerConfiguration.getApiUrl());
        }
        catch (MalformedURLException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        return new JavaDebugConnectionData(apiUrl.getHost(), debugPort.intValue());
    }
}

