/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationTypesRegistrar;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunConfigurationCreator {
    private Project myProject;

    public DockerRunConfigurationCreator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/DockerRunConfigurationCreator", "<init>"));
        }
        this.myProject = project;
    }

    public void createRunConfiguration(@NotNull DeploymentSource deploymentSource, @NotNull DockerDeploymentConfiguration deploymentConfiguration, @Nullable RemoteServer server, @Nullable Executor executor) {
        if (deploymentSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentSource", "com/intellij/docker/DockerRunConfigurationCreator", "createRunConfiguration"));
        }
        if (deploymentConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentConfiguration", "com/intellij/docker/DockerRunConfigurationCreator", "createRunConfiguration"));
        }
        DeployToServerConfigurationType configurationType = DeployToServerConfigurationTypesRegistrar.getDeployConfigurationType((ServerType)DockerCloudType.getInstance());
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        ConfigurationFactoryEx factory = configurationType.getFactory();
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(configurationType.getDisplayName(), (ConfigurationFactory)factory);
        settings.setTemporary(true);
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)settings.getConfiguration();
        if (server != null) {
            runConfiguration.setServerName(server.getName());
        }
        runConfiguration.setDeploymentSource(deploymentSource);
        runConfiguration.setDeploymentConfiguration((DeploymentConfiguration)deploymentConfiguration);
        if (RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)"Create Deployment Configuration", (Executor)executor)) {
            runManager.addConfiguration(settings, runManager.isConfigurationShared(settings), runManager.getBeforeRunTasks((RunConfiguration)runConfiguration), false);
            runManager.setSelectedConfiguration(settings);
            if (executor != null) {
                ProgramRunnerUtil.executeConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (Executor)executor);
            }
        }
    }
}

