/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerComposeDeploymentRuntime;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentRuntime;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerParseCliConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.cli.DockerParseCliCallback;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSource;
import com.intellij.docker.deploymentSource.DockerDeploymentSource;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryAuthCallback;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import icons.DockerIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerServerRuntimeInstance
extends CloudServerRuntimeInstance<DockerDeploymentConfiguration, DockerAgent, DockerCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + DockerServerRuntimeInstance.class.getName()));
    private static final String SPECIFICS_MODULE_NAME = "Docker-agent-impl-rt";
    private static final String SPECIFICS_JAR_PATH = "specifics/dockerSpecifics.jar";
    private List<DockerDeploymentRuntime> myDeploymentRuntimes;
    private Map<String, DockerComposeDeploymentRuntime> myComposeDeploymentRuntimes;
    private Map<String, DockerApplicationRuntime> myApplicationName2Runtime;
    private Map<String, String> myContainerId2Name;
    private final DockerApplicationRuntime myContainersGroup;
    private final DockerApplicationRuntime myImagesGroup;

    public DockerServerRuntimeInstance(@NotNull DockerCloudConfiguration configuration, @NotNull ServerTaskExecutor taskExecutor, @NotNull List<File> libraryFiles) throws Exception {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/DockerServerRuntimeInstance", "<init>"));
        }
        if (taskExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskExecutor", "com/intellij/docker/DockerServerRuntimeInstance", "<init>"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/docker/DockerServerRuntimeInstance", "<init>"));
        }
        super((CloudAgentConfigBase)configuration, taskExecutor, libraryFiles, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, DockerAgent.class, "com.intellij.docker.agent.DockerAgentImpl");
        this.myDeploymentRuntimes = new ArrayList<DockerDeploymentRuntime>();
        this.myComposeDeploymentRuntimes = new HashMap<String, DockerComposeDeploymentRuntime>();
        this.myApplicationName2Runtime = new HashMap<String, DockerApplicationRuntime>();
        this.myContainerId2Name = new HashMap<String, String>();
        this.myContainersGroup = new ContainersApplicationGroupRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor());
        this.myImagesGroup = new ImagesApplicationGroupRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor());
    }

    public AgentTaskExecutor getDockerAgentTaskExecutor() {
        return super.getAgentTaskExecutor();
    }

    public void connect(final ServerConnector.ConnectionCallback<DockerDeploymentConfiguration> callback) {
        this.getAgentTaskExecutor().execute(() -> {
            ((DockerAgent)this.getAgent()).connect((DockerAgentConfig)this.getConfiguration(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message) {
                    LOG.debug(message);
                }
            }, (CloudAgentErrorHandler)this.getAgentTaskExecutor());
            return null;
        }, (CallbackWrapper)new CallbackWrapper<Void>(){

            public void onSuccess(Void result) {
                callback.connected((ServerRuntimeInstance)DockerServerRuntimeInstance.this);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public void deploy(@NotNull DeploymentTask<DockerDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/docker/DockerServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/docker/DockerServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/DockerServerRuntimeInstance", "deploy"));
        }
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/docker/DockerServerRuntimeInstance", "lambda$deploy$1"));
            }
            if (logManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/docker/DockerServerRuntimeInstance", "lambda$deploy$1"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/DockerServerRuntimeInstance", "lambda$deploy$1"));
            }
            for (DockerDeploymentRuntime deploymentRuntime : new ArrayList<DockerDeploymentRuntime>(this.myDeploymentRuntimes)) {
                if (deploymentRuntime.getConfiguration() != task.getConfiguration()) continue;
                deploymentRuntime.setOutdated();
                this.myDeploymentRuntimes.remove((Object)deploymentRuntime);
            }
            if (task.getSource() instanceof DockerComposeDeploymentSource) {
                DockerComposeDeploymentRuntime composeDeploymentRuntime = new DockerComposeDeploymentRuntime((DockerAgent)this.getAgent(), task, logManager, this.getTaskExecutor(), this.getAgentTaskExecutor(), (DockerCloudConfiguration)this.getConfiguration());
                String deploymentName = this.getDeploymentName(task.getSource(), (DockerDeploymentConfiguration)task.getConfiguration());
                this.myComposeDeploymentRuntimes.put(deploymentName, composeDeploymentRuntime);
                composeDeploymentRuntime.deploy(callback);
            } else {
                DockerDeploymentRuntime deploymentRuntime = new DockerDeploymentRuntime((DockerAgent)this.getAgent(), task, logManager, this.getTaskExecutor(), this.getAgentTaskExecutor(), (DockerCloudConfiguration)this.getConfiguration(), this.myContainersGroup){

                    @Override
                    public String getContainerName() {
                        return (String)DockerServerRuntimeInstance.this.myContainerId2Name.get(this.getContainerId());
                    }
                };
                this.myDeploymentRuntimes.add(deploymentRuntime);
                deploymentRuntime.deploy(callback);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.getTaskExecutor().submit(() -> {
            for (DockerDeploymentRuntime deploymentRuntime : this.myDeploymentRuntimes) {
                deploymentRuntime.setOutdated();
            }
            ((DockerAgent)this.getAgent()).disconnect();
        });
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication applicationIdentity) {
        DockerComposeDeploymentRuntime.ServiceRuntime service;
        final String applicationName = applicationIdentity.getName();
        DockerAgentApplication application = (DockerAgentApplication)applicationIdentity;
        this.myContainerId2Name.put(application.getContainerId(), application.getContainerName());
        DockerApplicationRuntime result = (DockerApplicationRuntime)((Object)ContainerUtil.getOrCreate(this.myApplicationName2Runtime, (Object)applicationName, (Factory)new Factory<DockerApplicationRuntime>(){

            public DockerApplicationRuntime create() {
                return new DockerApplicationRuntime(DockerServerRuntimeInstance.this.getTaskExecutor(), DockerServerRuntimeInstance.this.getAgentTaskExecutor(), applicationName, null);
            }
        }));
        result.setApplication(application);
        String containerId = application.getContainerId();
        DockerApplicationRuntime parent = containerId == null ? this.myImagesGroup : ((service = this.findService(containerId)) == null ? this.myContainersGroup : service);
        result.setParent(parent);
        return result;
    }

    @Nullable
    private DockerComposeDeploymentRuntime.ServiceRuntime findService(String containerId) {
        for (DockerComposeDeploymentRuntime composeDeploymentRuntime : this.myComposeDeploymentRuntimes.values()) {
            for (DockerComposeDeploymentRuntime.ServiceRuntime serviceRuntime : composeDeploymentRuntime.getServiceRuntimes()) {
                if (!serviceRuntime.getContainerIds().contains(containerId)) continue;
                return serviceRuntime;
            }
        }
        return null;
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/DockerServerRuntimeInstance", "getDeploymentName"));
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName(null, source, configuration);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    @NotNull
    public String getRuntimeDeploymentName(@NotNull DeploymentRuntime deploymentRuntime, @NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        if (deploymentRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentRuntime", "com/intellij/docker/DockerServerRuntimeInstance", "getRuntimeDeploymentName"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/DockerServerRuntimeInstance", "getRuntimeDeploymentName"));
        }
        String string = DockerServerRuntimeInstance.doGetDeploymentName((DockerApplicationRuntime)deploymentRuntime, source, configuration);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/DockerServerRuntimeInstance", "getRuntimeDeploymentName"));
        }
        return string;
    }

    private static String doGetDeploymentName(@Nullable DockerApplicationRuntime applicationRuntime, @NotNull DeploymentSource source, DockerDeploymentConfiguration configuration) {
        String sourceName;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/DockerServerRuntimeInstance", "doGetDeploymentName"));
        }
        boolean hasDeploymentRuntime = applicationRuntime != null;
        StringBuilder result = new StringBuilder();
        if (source instanceof DockerComposeDeploymentSource) {
            result.append("Compose:");
        } else {
            String containerName = hasDeploymentRuntime ? applicationRuntime.getContainerName() : configuration.getContainerName();
            result.append(StringUtil.isEmpty((String)containerName) ? "<unknown>" : containerName);
        }
        String string = sourceName = source instanceof DockerDeploymentSource ? ((DockerDeploymentSource)source).getPresentableDeploymentName(configuration, hasDeploymentRuntime) : "Artifact: " + source.getPresentableName();
        if (StringUtil.isNotEmpty((String)sourceName)) {
            result.append("  ");
            result.append(sourceName);
        }
        return result.toString();
    }

    public void parseCliOptions(DockerParseCliConfig parseCliConfig, DockerAgentPathMapper pathMapper, final DockerParseCliCallback callback) {
        this.getTaskExecutor().submit(() -> this.getAgentTaskExecutor().execute(() -> ((DockerAgent)this.getAgent()).parseCliOptions(parseCliConfig, pathMapper), (CallbackWrapper)new CallbackWrapper<DockerAgentContainerConfig>(){

            public void onSuccess(DockerAgentContainerConfig result) {
                callback.succeeded(result);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        }), (RemoteOperationCallback)callback);
    }

    public void pullImage(DockerRepositoryModel repositoryModel, final ParameterizedRunnable<String> onSuccess) {
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        final String qualifiedTag = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return ((DockerAgent)DockerServerRuntimeInstance.this.getAgent()).pullImage(repositoryConfig, progressCallback);
            }

            @Override
            protected void succeeded() {
                onSuccess.run((Object)qualifiedTag);
            }
        }.performAsyncWithNotification(this.getTaskExecutor(), this.getAgentTaskExecutor(), "Pulling " + qualifiedTag, qualifiedTag + " pulled successfully");
    }

    public void imageRegistryAuth(DockerRegistry registry, RegistryAuthCallback callback) {
        this.getTaskExecutor().submit(() -> {
            try {
                this.getAgentTaskExecutor().execute(() -> {
                    ((DockerAgent)this.getAgent()).imageRegistryAuth(registry.getAuthConfig());
                    return null;
                });
                callback.succeeded();
            }
            catch (ServerRuntimeException e) {
                callback.errorOccurred(e.getMessage());
            }
        });
    }

    protected List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        ArrayList<CloudApplicationRuntime> result = new ArrayList<CloudApplicationRuntime>();
        result.add(this.myContainersGroup);
        result.add(this.myImagesGroup);
        try {
            final Semaphore semaphore = new Semaphore();
            for (DockerComposeDeploymentRuntime composeDeploymentRuntime : this.myComposeDeploymentRuntimes.values()) {
                semaphore.down();
                composeDeploymentRuntime.pollServiceContainers(new DockerComposeDeploymentRuntime.CollectingContainerIdsCallback(){

                    @Override
                    public void checkServiceContainerIds(DockerComposeDeploymentRuntime.ServiceRuntime runtime) {
                    }

                    @Override
                    public void allServicesProcessed() {
                        semaphore.up();
                    }
                });
                result.addAll(composeDeploymentRuntime.getServiceRuntimes());
            }
            semaphore.waitFor();
        }
        catch (ExecutionException e) {
            throw new ServerRuntimeException((Throwable)e);
        }
        result.addAll(super.getApplications());
        return result;
    }

    public static class ImagesApplicationGroupRuntime
    extends ApplicationGroupRuntime {
        public ImagesApplicationGroupRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor) {
            super(taskExecutor, agentTaskExecutor, DockerBundle.getText("DockerServerRuntimeInstance.ImagesApplicationGroupRuntime.groupName", new Object[0]), DockerIcons.ImagesList_2);
        }
    }

    public static class ContainersApplicationGroupRuntime
    extends ApplicationGroupRuntime {
        public ContainersApplicationGroupRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor) {
            super(taskExecutor, agentTaskExecutor, DockerBundle.getText("DockerServerRuntimeInstance.ContainersApplicationGroupRuntime.groupName", new Object[0]), DockerIcons.ContainersList_3);
        }
    }

    public static class ApplicationGroupRuntime
    extends DockerApplicationRuntime {
        private final DeploymentStatus myStatus;

        public ApplicationGroupRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, String groupName, Icon groupIcon) {
            super(taskExecutor, agentTaskExecutor, groupName, null);
            this.myStatus = new DeploymentStatus(groupIcon, groupName, false);
        }

        @Override
        @Nullable
        public DeploymentStatus getStatus() {
            return this.myStatus;
        }
    }
}

