/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.action.ImageActionBase;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSource;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import icons.DockerIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CreateContainerAction
extends ImageActionBase {
    public CreateContainerAction() {
        super("Create container", "Create and run container for the selected image", DockerIcons.CreateContainer);
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, DeploymentNode node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/docker/action/CreateContainerAction", "doActionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RemoteServer server = (RemoteServer)node.getServerNode().getValue();
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        if (applicationRuntime == null) {
            return;
        }
        String imageId = applicationRuntime.getImageId();
        ListPopup popup = new Case(project, (RemoteServer<DockerCloudConfiguration>)server, imageId).createPopup();
        if (e.getInputEvent() instanceof MouseEvent && e.getInputEvent().getComponent() instanceof ActionButton) {
            popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static class Case {
        private final DockerCloudType myCloudType = DockerCloudType.getInstance();
        private final Project myProject;
        private final RemoteServer<DockerCloudConfiguration> myServer;
        private final String myImageId;

        public Case(Project project, RemoteServer<DockerCloudConfiguration> server, String imageId) {
            this.myProject = project;
            this.myServer = server;
            this.myImageId = imageId;
        }

        public ListPopup createPopup() {
            DeploymentConfigurationManager configurationManager = DeploymentConfigurationManager.getInstance((Project)this.myProject);
            ArrayList<Object> list = new ArrayList<Object>(ContainerUtil.filter((Collection)configurationManager.getDeploymentConfigurations((ServerType)this.myCloudType), this.createAccountAndImageCondition()));
            list.add(null);
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RunnerAndConfigurationSettings>("Create container", list){

                public Icon getIconFor(RunnerAndConfigurationSettings value) {
                    return null;
                }

                @NotNull
                public String getTextFor(RunnerAndConfigurationSettings value) {
                    String string = value != null ? value.getName() : "Create...";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/action/CreateContainerAction$Case$1", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(RunnerAndConfigurationSettings selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> {
                        if (selectedValue != null) {
                            ProgramRunnerUtil.executeConfiguration((Project)myProject, (RunnerAndConfigurationSettings)selectedValue, (Executor)DefaultRunExecutor.getRunExecutorInstance());
                        } else {
                            this.createAndRunImageConfiguration();
                        }
                    });
                }
            });
        }

        private void createAndRunImageConfiguration() {
            DockerImageDeploymentSource deploymentSource = DockerImageDeploymentSourceType.getInstance().getDeploymentSource();
            DockerDeploymentConfiguration deploymentConfiguration = (DockerDeploymentConfiguration)this.myCloudType.createDeploymentConfigurator(this.myProject).createDefaultConfiguration((DeploymentSource)deploymentSource);
            deploymentConfiguration.setImageTag(this.myImageId);
            new DockerRunConfigurationCreator(this.myProject).createRunConfiguration(deploymentSource, deploymentConfiguration, this.myServer, DefaultRunExecutor.getRunExecutorInstance());
        }

        private Condition<RunnerAndConfigurationSettings> createAccountAndImageCondition() {
            return settings -> {
                DeployToServerRunConfiguration configuration = (DeployToServerRunConfiguration)settings.getConfiguration();
                return StringUtil.equals((CharSequence)this.myServer.getName(), (CharSequence)configuration.getServerName()) && configuration.getDeploymentSource() instanceof DockerImageDeploymentSource && StringUtil.equals((CharSequence)((DockerDeploymentConfiguration)configuration.getDeploymentConfiguration()).getImageTag(), (CharSequence)this.myImageId);
            };
        }
    }
}

