/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.action.ContainerActionBase;
import com.intellij.docker.exec.ExecCommand;
import com.intellij.docker.exec.ExecCommandManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionBase;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecInContainerAction
extends ContainerActionBase {
    public ExecInContainerAction() {
        super("Exec", "Run a command in the selected container", null);
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, DeploymentNode node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/docker/action/ExecInContainerAction", "doActionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)this.getApplicationRuntime(node);
        if (applicationRuntime == null) {
            return;
        }
        ListPopup popup = new Case(project, applicationRuntime, content, node).createPopup();
        popup.showInBestPositionFor(e.getDataContext());
    }

    protected boolean isEnabled4(DeploymentNode node) {
        Deployment deployment = (Deployment)node.getValue();
        return deployment.getStatus() == DeploymentStatus.DEPLOYED;
    }

    private class Case {
        private final Project myProject;
        private final DockerApplicationRuntime myApplicationRuntime;
        private final ServersToolWindowContent myContent;
        private final DeploymentNode myNode;

        public Case(Project project, DockerApplicationRuntime applicationRuntime, ServersToolWindowContent content, DeploymentNode node) {
            this.myProject = project;
            this.myApplicationRuntime = applicationRuntime;
            this.myContent = content;
            this.myNode = node;
        }

        public ListPopup createPopup() {
            ArrayList<ExecCommand> list = new ArrayList<ExecCommand>(ExecCommandManager.getInstance(this.myProject).getImageCommands(this.myApplicationRuntime.getImageId()));
            list.add(null);
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ExecCommand>("Run command in container", list){

                public Icon getIconFor(ExecCommand value) {
                    return null;
                }

                @NotNull
                public String getTextFor(ExecCommand value) {
                    String string = value != null ? value.getCommand() : "Create...";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/action/ExecInContainerAction$Case$1", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(ExecCommand selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> Case.this.createAndRunExecSession(selectedValue));
                }
            });
        }

        private void createAndRunExecSession(@Nullable ExecCommand storedExecCommand) {
            String command;
            if (storedExecCommand == null) {
                command = Messages.showInputDialog((Project)this.myProject, (String)"Command:", (String)"Exec", null);
                if (command == null) {
                    return;
                }
                ExecCommandManager.getInstance(this.myProject).addCommand(this.myApplicationRuntime.getImageId(), command);
            } else {
                command = storedExecCommand.getCommand();
            }
            String logName = "Exec: " + command;
            ApplicationActionBase.SelectLogRunnable onDone = new ApplicationActionBase.SelectLogRunnable((ApplicationActionBase)ExecInContainerAction.this, this.myContent, this.myNode, logName);
            this.myApplicationRuntime.exec(this.myProject, command, logName, (Runnable)onDone);
        }
    }
}

