/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.PullImageConfigurable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeAction;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import icons.DockerIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PullImageAction
extends ServersTreeAction<ServersTreeStructure.RemoteServerNode> {
    public PullImageAction() {
        super("Pull image", "Pull image from repository", DockerIcons.PullImage);
    }

    protected Class<ServersTreeStructure.RemoteServerNode> getTargetNodeClass() {
        return ServersTreeStructure.RemoteServerNode.class;
    }

    protected boolean isEnabled4(ServersTreeStructure.RemoteServerNode node) {
        return node.isConnected();
    }

    protected void doActionPerformed(final @NotNull ServersToolWindowContent content, AnActionEvent e, ServersTreeStructure.RemoteServerNode node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/docker/action/PullImageAction", "doActionPerformed"));
        }
        final ServerConnection connection = ServerConnectionManager.getInstance().getConnection(node.getServer());
        if (connection == null) {
            return;
        }
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/docker/action/PullImageAction$1", "connected"));
                }
                PullImageAction.doPullImage(content.getProject(), (DockerServerRuntimeInstance)serverRuntimeInstance, (ParameterizedRunnable<String>)new ImageSelectionCase(connection, content));
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/action/PullImageAction$1", "errorOccurred"));
                }
            }
        });
    }

    private static void doPullImage(Project project, DockerServerRuntimeInstance serverRuntime, ParameterizedRunnable<String> onSuccess) {
        DockerRepositoryModel model = new DockerRepositoryModel();
        if (!ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PullImageConfigurable(model))) {
            return;
        }
        serverRuntime.pullImage(model, onSuccess);
    }

    protected boolean isVisible4(ServersTreeStructure.RemoteServerNode node) {
        return node.getServer().getType() == DockerCloudType.getInstance();
    }

    private static class ImageSelectionCase
    implements ParameterizedRunnable<String> {
        private final ServerConnection<?> myConnection;
        private final ServersToolWindowContent myContent;

        public ImageSelectionCase(ServerConnection<?> connection, ServersToolWindowContent content) {
            this.myConnection = connection;
            this.myContent = content;
        }

        public void run(String imageRepoTag) {
            Semaphore semaphore = new Semaphore();
            semaphore.down();
            this.myConnection.computeDeployments(() -> {
                semaphore.up();
                for (Deployment deployment : this.myConnection.getDeployments()) {
                    Set<String> repoTags;
                    DockerApplicationRuntime applicationRuntime = (DockerApplicationRuntime)deployment.getRuntime();
                    if (applicationRuntime == null || (repoTags = applicationRuntime.getImageRepoTags()) == null || !repoTags.contains(imageRepoTag)) continue;
                    UIUtil.invokeLaterIfNeeded(() -> this.myContent.select(this.myConnection, deployment.getName()));
                    break;
                }
            });
            semaphore.waitFor();
        }
    }
}

