/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.cli.DockerParseCliConfigImpl;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DockerParseCliConfigurable
implements Configurable {
    private JTextField myCliOptionsTextField;
    private TextFieldWithBrowseButton myJsonFileTextField;
    private JPanel myMainPanel;
    private final DockerParseCliConfigImpl myConfig;

    public DockerParseCliConfigurable(DockerParseCliConfigImpl config, final Project project) {
        this.myConfig = config;
        this.$$$setupUI$$$();
        this.myJsonFileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSaverDescriptor descriptor = new FileSaverDescriptor("Save CLI options", "Select path to save parsed CLI options to.", new String[]{"json"});
                FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
                VirtualFileWrapper fileWrapper = saverDialog.save(project.getBaseDir(), "container_settings.json");
                if (fileWrapper == null) {
                    return;
                }
                DockerParseCliConfigurable.this.myJsonFileTextField.setText(fileWrapper.getFile().getAbsolutePath());
            }
        });
    }

    @Nls
    public String getDisplayName() {
        return "Parse CLI to JSON";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        String cliOptions = this.myCliOptionsTextField.getText();
        if (StringUtil.isEmpty((String)cliOptions)) {
            throw new ConfigurationException("Specify CLI options");
        }
        String jsonPath = this.myJsonFileTextField.getText();
        if (StringUtil.isEmpty((String)jsonPath)) {
            throw new ConfigurationException("Specify path to JSON file");
        }
        this.myConfig.setCliOptionsLine(cliOptions);
        this.myConfig.setJsonPath(jsonPath);
    }

    public void reset() {
        this.myCliOptionsTextField.setText(this.myConfig.getCliOptionsLine());
        this.myJsonFileTextField.setText(this.myConfig.getJsonPath());
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("CLI options:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCliOptionsTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("JSON file:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJsonFileTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

