/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerDeploymentSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import icons.DockerIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeDeploymentSource
extends DockerDeploymentSource {
    private final Project myProject;
    private final File myFile;

    public DockerComposeDeploymentSource(Project project, File dockerComposeFile) {
        this.myProject = project;
        this.myFile = dockerComposeFile.isAbsolute() ? dockerComposeFile : new File(project.getBasePath(), dockerComposeFile.getPath());
    }

    public DockerComposeDeploymentSource(Project project, VirtualFile dockerComposeFile) {
        this.myProject = project;
        this.myFile = VfsUtilCore.virtualToIoFile((VirtualFile)dockerComposeFile);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(DockerDeploymentConfiguration deploymentConfiguration, boolean hasDeploymentRuntime) {
        String string = this.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSource", "getPresentableDeploymentName"));
        }
        return string;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSource", "getFilePath"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String relativePath;
        String basePath = this.myProject.getBasePath();
        if (basePath != null && (relativePath = FileUtil.getRelativePath((File)new File(basePath), (File)this.myFile)) != null) {
            String string = relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSource", "getPresentableName"));
            }
            return string;
        }
        String string = this.myFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSource", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return DockerIcons.DockerComposeFile;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerComposeDeploymentSource)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)((DockerComposeDeploymentSource)o).myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(DockerComposeDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSource", "getType"));
        }
        return deploymentSourceType;
    }
}

