/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.deploymentSource.DockerComposeDeploymentSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DockerComposeDeploymentSourceType
extends DeploymentSourceType<DockerComposeDeploymentSource> {
    private static final String PATH_ATTRIBUTE = "path";
    public static final String DOCKER_COMPOSE_FILE = "docker-compose.yml";

    public DockerComposeDeploymentSourceType() {
        super(DOCKER_COMPOSE_FILE);
    }

    @NotNull
    public DockerComposeDeploymentSource load(@NotNull Element tag, @NotNull Project project) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType", "load"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType", "load"));
        }
        DockerComposeDeploymentSource dockerComposeDeploymentSource = new DockerComposeDeploymentSource(project, new File(FileUtil.toSystemDependentName((String)tag.getAttributeValue(PATH_ATTRIBUTE))));
        if (dockerComposeDeploymentSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType", "load"));
        }
        return dockerComposeDeploymentSource;
    }

    public void save(@NotNull DockerComposeDeploymentSource source, @NotNull Element tag) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType", "save"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType", "save"));
        }
        tag.setAttribute(PATH_ATTRIBUTE, FileUtil.toSystemIndependentName((String)source.getFilePath()));
    }
}

