/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerDeploymentSource;
import com.intellij.docker.deploymentSource.DockerfileDeploymentSourceType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import icons.DockerIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerfileDeploymentSource
extends DockerDeploymentSource {
    private final Project myProject;
    private final File myFile;

    public DockerfileDeploymentSource(Project project, VirtualFile dockerfile) {
        this.myProject = project;
        this.myFile = VfsUtilCore.virtualToIoFile((VirtualFile)dockerfile);
    }

    public DockerfileDeploymentSource(Project project, File dockerfile) {
        this.myProject = project;
        this.myFile = dockerfile.isAbsolute() ? dockerfile : new File(project.getBasePath(), dockerfile.getPath());
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerfileDeploymentSource", "getFilePath"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String basePath = this.myProject.getBasePath();
        String relativePath = basePath == null ? null : FileUtil.getRelativePath((File)new File(basePath), (File)this.myFile);
        String string = relativePath == null ? this.myFile.getAbsolutePath() : relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerfileDeploymentSource", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(DockerDeploymentConfiguration deploymentConfiguration, boolean hasDeploymentRuntime) {
        String string = "Dockerfile: " + this.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerfileDeploymentSource", "getPresentableDeploymentName"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return DockerIcons.DockerFile_1;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isArchive() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DockerfileDeploymentSource)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)((DockerfileDeploymentSource)o).myFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myFile);
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(DockerfileDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/deploymentSource/DockerfileDeploymentSource", "getType"));
        }
        return deploymentSourceType;
    }
}

