/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.highlighting.highlight;

import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighterColors;
import com.intellij.docker.dockerFile.lexer.DockerLexer;
import com.intellij.docker.dockerFile.lexer.DockerTokenTypeSets;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerSyntaxHighlighter
extends SyntaxHighlighterBase {
    protected final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    protected final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    public DockerSyntaxHighlighter() {
        this.fillMap(DockerTokenTypeSets.COMMANDS, DockerSyntaxHighlighterColors.KEYWORD);
        this.putTokenType(DockerTokenTypes.SIMPLE_OPERATOR, DockerSyntaxHighlighterColors.KEYWORD);
        this.putTokenType(DockerTokenTypes.COMPOSITE_OPERATOR, DockerSyntaxHighlighterColors.KEYWORD);
        this.putTokenType(DockerTokenTypeSets.SINGLE_LINE_COMMENT, DockerSyntaxHighlighterColors.COMMENTS);
        this.putTokenType(DockerTokenTypes.DOT, DockerSyntaxHighlighterColors.DOT);
        this.putTokenType(DockerTokenTypes.COMMA, DockerSyntaxHighlighterColors.COMMA);
        this.putTokenType(DockerTokenTypes.INTEGER_LITERAL, DockerSyntaxHighlighterColors.NUMBER);
        this.putTokenType(DockerTokenTypes.FLOATING_POINT_LITERAL, DockerSyntaxHighlighterColors.NUMBER);
        this.fillMap(DockerTokenTypeSets.STRING_PARTS, DockerSyntaxHighlighterColors.STRING);
        this.putTokenType(DockerTokenTypes.LPAREN, DockerSyntaxHighlighterColors.PARENTHS);
        this.putTokenType(DockerTokenTypes.RPAREN, DockerSyntaxHighlighterColors.PARENTHS);
        this.putTokenType(DockerTokenTypes.LBRACKET, DockerSyntaxHighlighterColors.BRACKETS);
        this.putTokenType(DockerTokenTypes.RBRACKET, DockerSyntaxHighlighterColors.BRACKETS);
        this.putTokenType(DockerTokenTypes.LBRACKET, DockerSyntaxHighlighterColors.BRACKETS);
        this.putTokenType(DockerTokenTypes.RBRACKET, DockerSyntaxHighlighterColors.BRACKETS);
    }

    protected void fillMap(TokenSet tokenSet, TextAttributesKey key) {
        SyntaxHighlighterBase.fillMap(this.keys1, (TokenSet)tokenSet, (TextAttributesKey)key);
    }

    protected void putTokenType(IElementType elementType, TextAttributesKey key) {
        this.keys1.put(elementType, key);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = DockerSyntaxHighlighter.pack((TextAttributesKey)this.keys2.get(tokenType), (TextAttributesKey)this.keys1.get(tokenType));
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerSyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        DockerLexer dockerLexer = new DockerLexer();
        if (dockerLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerSyntaxHighlighter", "getHighlightingLexer"));
        }
        return dockerLexer;
    }
}

