/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.highlighting.highlight;

import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighter;
import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighterColors;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import icons.DockerIcons;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerfileColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(DockerBundle.getText("dockerfile.brackets", new Object[0]), DockerSyntaxHighlighterColors.BRACKETS), new AttributesDescriptor(DockerBundle.getText("dockerfile.comma", new Object[0]), DockerSyntaxHighlighterColors.COMMA), new AttributesDescriptor(DockerBundle.getText("dockerfile.comments", new Object[0]), DockerSyntaxHighlighterColors.COMMENTS), new AttributesDescriptor(DockerBundle.getText("dockerfile.dot", new Object[0]), DockerSyntaxHighlighterColors.DOT), new AttributesDescriptor(DockerBundle.getText("dockerfile.keyword", new Object[0]), DockerSyntaxHighlighterColors.KEYWORD), new AttributesDescriptor(DockerBundle.getText("dockerfile.number", new Object[0]), DockerSyntaxHighlighterColors.NUMBER), new AttributesDescriptor(DockerBundle.getText("dockerfile.parenths", new Object[0]), DockerSyntaxHighlighterColors.PARENTHS), new AttributesDescriptor(DockerBundle.getText("dockerfile.string", new Object[0]), DockerSyntaxHighlighterColors.STRING), new AttributesDescriptor(DockerBundle.getText("dockerfile.variable", new Object[0]), DockerSyntaxHighlighterColors.VARIABLE)};

    @Nullable
    public Icon getIcon() {
        return DockerIcons.Docker;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        DockerSyntaxHighlighter dockerSyntaxHighlighter = new DockerSyntaxHighlighter();
        if (dockerSyntaxHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerfileColorSettingsPage", "getHighlighter"));
        }
        return dockerSyntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        if ("# Dockerfile example\nFROM scratch\nMAINTAINER John Doe (J.D.) <jd@example.com>\nENV <variable>PORT_TO_EXPOSE</variable>=4242\nRUN /bin/bash\nRUN echo Scratch running ... > /dev/null\nCMD [/usr/bin/zsh, -D]\nCMD echo \"String....\"\nEXPOSE $<variable>PORT_TO_EXPOSE</variable> 8080\nVOLUME [/my_files]\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerfileColorSettingsPage", "getDemoText"));
        }
        return "# Dockerfile example\nFROM scratch\nMAINTAINER John Doe (J.D.) <jd@example.com>\nENV <variable>PORT_TO_EXPOSE</variable>=4242\nRUN /bin/bash\nRUN echo Scratch running ... > /dev/null\nCMD [/usr/bin/zsh, -D]\nCMD echo \"String....\"\nEXPOSE $<variable>PORT_TO_EXPOSE</variable> 8080\nVOLUME [/my_files]\n";
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return Collections.singletonMap("variable", DockerSyntaxHighlighterColors.VARIABLE);
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerfileColorSettingsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerfileColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        if ("Dockerfile" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/highlighting/highlight/DockerfileColorSettingsPage", "getDisplayName"));
        }
        return "Dockerfile";
    }
}

