/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.parser;

import com.intellij.docker.dockerFile.lexer.DockerLexer;
import com.intellij.docker.dockerFile.parser.DockerParserDefinition;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.plugins.docker.dockerFile.parser.DockerfileParser;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvRegularDeclaration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerParserUtil {
    @Nullable
    public static <T> T parseFromString(@NotNull String text, IElementType type, Class<T> expectedClass) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/docker/dockerFile/parser/DockerParserUtil", "parseFromString"));
        }
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        PsiBuilder psiBuilder = factory.createBuilder((ParserDefinition)new DockerParserDefinition(), (Lexer)new DockerLexer(), (CharSequence)text);
        DockerfileParser parser = new DockerfileParser();
        parser.parseLight(type, psiBuilder);
        ASTNode astNode = (ASTNode)ReadAction.compute(() -> ((PsiBuilder)psiBuilder).getTreeBuilt());
        PsiElement psiResult = DockerTokenTypes.Factory.createElement(astNode);
        if (psiResult == null || PsiTreeUtil.hasErrorElements((PsiElement)psiResult)) {
            return null;
        }
        return expectedClass.isInstance(psiResult) ? (T)expectedClass.cast(psiResult) : null;
    }

    @NotNull
    public static PsiElement createNewIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/dockerFile/parser/DockerParserUtil", "createNewIdentifier"));
        }
        String textWithNewName = name + "=42";
        DockerFileEnvRegularDeclaration declaration = DockerParserUtil.parseFromString(textWithNewName, DockerTokenTypes.ENV_REGULAR_DECLARATION, DockerFileEnvRegularDeclaration.class);
        if (declaration == null) {
            throw new IllegalStateException("Can't parse to ENV declaration: " + textWithNewName);
        }
        PsiElement psiElement = declaration.getDeclaredName();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/parser/DockerParserUtil", "createNewIdentifier"));
        }
        return psiElement;
    }
}

