/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.parser.psi.impl;

import com.intellij.docker.dockerFile.parser.DockerParserUtil;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiNameDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiNameReference;
import com.intellij.docker.dockerFile.parser.psi.impl.DockerPsiCompositeElementImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvRegularDeclaration;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileEnvUnstructuredDeclaration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerPsiNameReferenceBase
extends DockerPsiCompositeElementImpl
implements DockerPsiNameReference {
    private static final Object[] NO_VARIANTS = new Object[0];

    public DockerPsiNameReferenceBase(ASTNode astNode) {
        super(astNode);
    }

    public PsiElement getElement() {
        return this;
    }

    public PsiReference getReference() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement referencingPart = Optional.ofNullable(this.getReferencedName()).orElse(this.getDollar());
        TextRange nameRange = referencingPart.getTextRange();
        return nameRange.shiftRight(-this.getTextOffset());
    }

    @Nullable
    public DockerPsiNameDeclaration resolve() {
        if (this.getReferencedName() == null) {
            return null;
        }
        String lookup = this.getReferencedName().getText();
        DockerPsiCommand curCommand = (DockerPsiCommand)PsiTreeUtil.getParentOfType((PsiElement)this, DockerPsiCommand.class);
        if (curCommand == null) {
            return null;
        }
        if (curCommand instanceof DockerFileEnvCommand) {
            DockerFileEnvRegularDeclaration curDeclaration;
            DockerFileEnvRegularDeclaration next = curDeclaration = (DockerFileEnvRegularDeclaration)PsiTreeUtil.getParentOfType((PsiElement)this, DockerFileEnvRegularDeclaration.class);
            while (next != null) {
                if (next.isDeclarationForName(lookup)) {
                    return next;
                }
                next = (DockerFileEnvRegularDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)next, DockerFileEnvRegularDeclaration.class);
            }
        }
        DockerPsiCommand next = curCommand;
        while (next != null) {
            if (next instanceof DockerFileEnvCommand) {
                DockerFileEnvUnstructuredDeclaration unstructured;
                DockerFileEnvCommand envCommand = (DockerFileEnvCommand)next;
                if (envCommand.getEnvUnstructuredDeclaration() != null && (unstructured = envCommand.getEnvUnstructuredDeclaration()).isDeclarationForName(lookup)) {
                    return unstructured;
                }
                for (DockerPsiNameDeclaration dockerPsiNameDeclaration : envCommand.getEnvRegularDeclarationList()) {
                    if (!dockerPsiNameDeclaration.isDeclarationForName(lookup)) continue;
                    return dockerPsiNameDeclaration;
                }
            }
            next = (DockerPsiCommand)PsiTreeUtil.getPrevSiblingOfType((PsiElement)next, DockerPsiCommand.class);
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        PsiElement namePsi = this.getReferencedName();
        String string = "$" + (namePsi == null ? "" : namePsi.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiNameReferenceBase", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.getReferencedName() == null) {
            throw new IncorrectOperationException("Single $ is not a real ref and should not be renamed");
        }
        PsiElement newRef = DockerParserUtil.createNewIdentifier(newElementName);
        ASTNode curRefNode = this.getReferencedName().getNode();
        PostprocessReformattingAspect.getInstance((Project)this.getProject()).disablePostprocessFormattingInside(() -> curRefNode.getTreeParent().replaceChild(curRefNode, newRef.getNode()));
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiNameReferenceBase", "bindToElement"));
        }
        return this;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof DockerPsiNameDeclaration)) {
            return false;
        }
        if (this.getReferencedName() == null) {
            return false;
        }
        if (element.getContainingFile() != this.getContainingFile()) {
            return false;
        }
        String lookup = this.getReferencedName().getText();
        return ((DockerPsiNameDeclaration)element).isDeclarationForName(lookup);
    }

    @NotNull
    public Object[] getVariants() {
        if (NO_VARIANTS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/dockerFile/parser/psi/impl/DockerPsiNameReferenceBase", "getVariants"));
        }
        return NO_VARIANTS;
    }

    public boolean isSoft() {
        return true;
    }
}

