/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.google.common.base.Optional;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.docker.machine.DockerMachineSettings;
import com.intellij.docker.machine.DockerMachineUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    public static final String ID = "reference.settingsDialog.application.dockerMachine";
    @NonNls
    public static final String HELP_TOPIC = "reference.settingsdialog.project.docker";
    private JPanel myMainPanel;
    private JBLabel myDockerMachineExecutableLabel;
    private TextFieldWithBrowseButton myDockerMachineExecutableField;
    private JBLabel myCheckResultLabel;
    private JButton myDetectButton;
    private final ReentrantLock myLock;
    private String myScheduledDockerMachineExecutable;
    private final ScheduledExecutorService myScheduledExecutorService;

    public DockerMachineConfigurable() {
        this.$$$setupUI$$$();
        this.myLock = new ReentrantLock();
        this.myScheduledExecutorService = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"Docker Machine Version");
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineConfigurable", "getId"));
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return "Docker";
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_TOPIC == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineConfigurable", "getHelpTopic"));
        }
        return HELP_TOPIC;
    }

    @Nullable
    public JComponent createComponent() {
        FileChooserDescriptor singleExecutableDescriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        this.myDockerMachineExecutableField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener("Select Docker Machine executable", "", (ComponentWithBrowseButton)this.myDockerMachineExecutableField, null, singleExecutableDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.myDockerMachineExecutableField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DockerMachineConfigurable.this.updateDockerMachineExecutable();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DockerMachineConfigurable.this.updateDockerMachineExecutable();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DockerMachineConfigurable.this.updateDockerMachineExecutable();
            }
        });
        this.myDetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Optional<String> optional = DockerMachineUtil.tryFindDockerMachineExecutable();
                if (optional.isPresent()) {
                    DockerMachineConfigurable.this.myDockerMachineExecutableField.getTextField().setText((String)optional.get());
                } else {
                    DockerMachineConfigurable.this.myDetectButton.setEnabled(false);
                    DockerMachineConfigurable.this.onError("Docker Machine executable could not be found");
                }
            }
        });
        return this.myMainPanel;
    }

    private void updateDockerMachineExecutable() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.myMainPanel);
        this.myLock.lock();
        try {
            boolean hasToBeScheduled = this.myScheduledDockerMachineExecutable == null;
            this.myScheduledDockerMachineExecutable = this.myDockerMachineExecutableField.getText();
            if (hasToBeScheduled) {
                this.myScheduledExecutorService.schedule(() -> {
                    String dockerMachineExecutable;
                    this.myLock.lock();
                    try {
                        dockerMachineExecutable = this.myScheduledDockerMachineExecutable;
                        this.myScheduledDockerMachineExecutable = null;
                    }
                    finally {
                        this.myLock.unlock();
                    }
                    DockerMachine dockerMachine = DockerMachine.getDockerMachine(dockerMachineExecutable);
                    try {
                        String version = dockerMachine.version();
                        ApplicationManager.getApplication().invokeLater(() -> this.onSuccess(version), modalityState);
                    }
                    catch (RuntimeException e) {
                        String errorMessage = e.getMessage();
                        ApplicationManager.getApplication().invokeLater(() -> this.onError(errorMessage), modalityState);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    protected void onError(String errorMessage) {
        this.myCheckResultLabel.setText(errorMessage);
        this.myCheckResultLabel.setForeground((Color)JBColor.RED);
        this.myCheckResultLabel.setIcon(UIUtil.getBalloonErrorIcon());
    }

    protected void onSuccess(String stdout) {
        this.myCheckResultLabel.setText(stdout);
        this.myCheckResultLabel.setForeground(UIUtil.getActiveTextColor());
        this.myCheckResultLabel.setIcon(UIUtil.getBalloonInformationIcon());
    }

    public boolean isModified() {
        DockerMachineSettings instance = DockerMachineSettings.getInstance();
        return !StringUtil.equals((CharSequence)this.getDockerMachineExecutable(), (CharSequence)instance.getDockerMachinePath());
    }

    public void apply() throws ConfigurationException {
        DockerMachineSettings.getInstance().setDockerMachinePath(this.getDockerMachineExecutable());
    }

    public String getDockerMachineExecutable() {
        return this.myDockerMachineExecutableField.getText();
    }

    public void reset() {
        String dockerMachinePath = DockerMachineSettings.getInstance().getDockerMachinePath();
        this.myDockerMachineExecutableField.setText(dockerMachinePath);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDockerMachineExecutableLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Docker Machine executable:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDockerMachineExecutableField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCheckResultLabel = jBLabel = new JBLabel();
        jBLabel.setForeground(new Color(-65536));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDetectButton = jButton = new JButton();
        jButton.setText("Detect");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

