/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.machine;

import com.google.common.base.Optional;
import com.intellij.docker.machine.DockerMachine;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerMachineUtil {
    public static final String DEFAULT_DOCKER_MACHINE_EXECUTABLE = "docker-machine";
    private static final String DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN = "docker-machine.exe";
    private static final String USR_LOCAL_BIN_PATH = "/usr/local/bin";
    private static final String PROGRAM_FILES_WIN_ENV = "ProgramFiles";
    private static final String PROGRAM_FILES_X86_WIN_ENV = "ProgramFiles(x86)";
    private static final String DOCKER_TOOLBOX_WIN_FOLDER = "Docker Toolbox";

    private DockerMachineUtil() {
    }

    @NotNull
    public static String getDefaultDockerMachineExecutable() {
        if (DEFAULT_DOCKER_MACHINE_EXECUTABLE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "getDefaultDockerMachineExecutable"));
        }
        return DEFAULT_DOCKER_MACHINE_EXECUTABLE;
    }

    @NotNull
    public static Optional<String> tryFindDockerMachineExecutable() {
        if (DockerMachineUtil.checkValidExecutable(DEFAULT_DOCKER_MACHINE_EXECUTABLE)) {
            Optional optional = Optional.of((Object)DEFAULT_DOCKER_MACHINE_EXECUTABLE);
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "tryFindDockerMachineExecutable"));
            }
            return optional;
        }
        if (SystemInfo.isMac || SystemInfo.isUnix) {
            String pathname = FileUtil.join((String[])new String[]{USR_LOCAL_BIN_PATH, DEFAULT_DOCKER_MACHINE_EXECUTABLE});
            if (DockerMachineUtil.checkExists(pathname)) {
                Optional optional = Optional.of((Object)pathname);
                if (optional == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "tryFindDockerMachineExecutable"));
                }
                return optional;
            }
        } else if (SystemInfo.isWindows) {
            String pathname;
            String pathname2;
            String programFiles = System.getenv(PROGRAM_FILES_WIN_ENV);
            if (programFiles != null && DockerMachineUtil.checkExists(pathname2 = FileUtil.join((String[])new String[]{programFiles, DOCKER_TOOLBOX_WIN_FOLDER, DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN}))) {
                Optional optional = Optional.of((Object)pathname2);
                if (optional == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "tryFindDockerMachineExecutable"));
                }
                return optional;
            }
            String programFilesX86 = System.getenv(PROGRAM_FILES_X86_WIN_ENV);
            if (programFilesX86 != null && DockerMachineUtil.checkExists(pathname = FileUtil.join((String[])new String[]{programFilesX86, DOCKER_TOOLBOX_WIN_FOLDER, DEFAULT_DOCKER_MACHINE_EXECUTABLE_WIN}))) {
                Optional optional = Optional.of((Object)pathname);
                if (optional == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "tryFindDockerMachineExecutable"));
                }
                return optional;
            }
        }
        Optional optional = Optional.absent();
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/machine/DockerMachineUtil", "tryFindDockerMachineExecutable"));
        }
        return optional;
    }

    private static boolean checkValidExecutable(@NotNull String pathname) {
        if (pathname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathname", "com/intellij/docker/machine/DockerMachineUtil", "checkValidExecutable"));
        }
        try {
            DockerMachine.getDockerMachine(pathname).version();
            return true;
        }
        catch (RuntimeException ignored) {
            return false;
        }
    }

    private static boolean checkExists(@NotNull String pathname) {
        if (pathname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathname", "com/intellij/docker/machine/DockerMachineUtil", "checkExists"));
        }
        File file = new File(pathname);
        return file.exists() && file.canExecute();
    }

    public static void startMachineWithProgressIndicator(@Nullable Project project, final @NotNull String machineName) {
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/intellij/docker/machine/DockerMachineUtil", "startMachineWithProgressIndicator"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Void, RuntimeException>(){

            public Void compute() {
                ProgressManager.progress((String)("Starting Docker Machine '" + machineName + "'"));
                DockerMachine.currentDockerMachine().start(machineName);
                return null;
            }
        }, "Starting Docker Machine", true, project);
    }
}

