/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRepoTag;
import com.intellij.docker.registry.DockerRepositoryModel;

public class DockerAgentRepositoryConfigImpl
implements DockerAgentRepositoryConfig {
    private final DockerRepositoryModel myModel;
    private final DockerRepoTag myRepoTag;

    public DockerAgentRepositoryConfigImpl(DockerRepositoryModel model) {
        this.myModel = model;
        DockerRegistry registry = model.getRegistry();
        this.myRepoTag = new DockerRepoTag(model.getRepository());
        if (this.myRepoTag.getAddress() == null) {
            this.myRepoTag.setQualifiedAddress(registry.getAddress());
        }
        if (this.myRepoTag.getNamespace() == null) {
            this.myRepoTag.setNamespace(registry.getUsername());
        }
        this.myRepoTag.setTag(model.getTag());
    }

    public DockerAuthConfig getAuthConfig() {
        return this.myModel.getRegistry().getAuthConfig();
    }

    public String getQualifiedRepository() {
        return this.myRepoTag.getQualifiedRepository();
    }

    public String getQualifiedTag() {
        return this.myRepoTag.getQualifiedRepoTag();
    }

    public String getTag() {
        return this.myModel.getTag();
    }
}

