/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerAuthConfigImpl;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.util.xmlb.annotations.Transient;

public class DockerRegistry
extends CloudConfigurationBase<DockerRegistry> {
    public static final String DOCKER_HUB_ADDRESS = "registry.hub.docker.com";
    public static final String[] PROVIDER_ADDRESSES = new String[]{"quay.io"};
    private String myName;
    private String myAddress;
    private String myUsername;

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public DockerRegistry withName(String name) {
        this.setName(name);
        return this;
    }

    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    public DockerAuthConfig getAuthConfig() {
        DockerAuthConfigImpl result = new DockerAuthConfigImpl();
        result.setServerAddress(this.myAddress);
        result.setUsername(this.myUsername);
        result.setPassword(this.getPasswordSafe());
        result.setEmail(this.getEmail());
        return result;
    }

    public boolean isDockerHub() {
        return StringUtil.equals((CharSequence)this.myAddress, (CharSequence)DOCKER_HUB_ADDRESS);
    }

    public boolean hasUserData() {
        return StringUtil.isNotEmpty((String)this.getUsername());
    }

    @Transient
    public boolean isPasswordSafe() {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes();
        return credentialAttributes != null && PasswordSafe.getInstance().get(credentialAttributes) != null;
    }

    private CredentialAttributes createCredentialAttributes() {
        String name = this.getName();
        return StringUtil.isEmpty((String)name) ? null : new CredentialAttributes("IntelliJ Platform Docker Registry - " + name, this.getUsername());
    }

    @Transient
    public void setPasswordSafe(String password) {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes();
        if (credentialAttributes != null) {
            PasswordSafe.getInstance().set(credentialAttributes, new Credentials(this.getUsername(), password), false);
            this.setPassword(null);
        } else {
            this.setPassword(password);
        }
    }

    @Transient
    public String getPasswordSafe() {
        CredentialAttributes credentialAttributes = this.createCredentialAttributes();
        if (credentialAttributes != null) {
            Credentials credentials = PasswordSafe.getInstance().get(credentialAttributes);
            return credentials == null ? this.getPassword() : credentials.getPasswordAsString();
        }
        return this.getPassword();
    }
}

