/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.registry.DockerRegistry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DockerRepoTag {
    private static final String REPOSITORY_PARTS_SEPARATOR = "/";
    private static final String TAG_SEPARATOR = ":";
    private String myAddress;
    private String myNamespace;
    private String myRepository;
    private String myTag;

    public DockerRepoTag(String repoTag) {
        List parts = StringUtil.split((String)repoTag, (String)REPOSITORY_PARTS_SEPARATOR);
        ListIterator partIt = parts.listIterator(parts.size());
        List repositoryWithTag = StringUtil.split((String)((String)partIt.previous()), (String)TAG_SEPARATOR);
        Iterator repositoryWithTagIt = repositoryWithTag.iterator();
        this.myRepository = (String)repositoryWithTagIt.next();
        if (repositoryWithTagIt.hasNext()) {
            this.myTag = (String)repositoryWithTagIt.next();
        }
        if (partIt.hasPrevious()) {
            this.myNamespace = (String)partIt.previous();
        }
        if (partIt.hasPrevious()) {
            this.myAddress = (String)partIt.previous();
        }
    }

    public String getAddress() {
        return this.myAddress;
    }

    public void setAddress(String address) {
        this.myAddress = address;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public void setNamespace(String namespace) {
        this.myNamespace = namespace;
    }

    public String getRepository() {
        return this.myRepository;
    }

    public void setRepository(String repository) {
        this.myRepository = repository;
    }

    public String getTag() {
        return this.myTag;
    }

    public void setTag(String tag) {
        this.myTag = tag;
    }

    public String getQualifiedAddress() {
        return StringUtil.notNullize((String)this.myAddress, (String)"registry.hub.docker.com");
    }

    public void setQualifiedAddress(String qualifiedAddress) {
        this.myAddress = StringUtil.equals((CharSequence)qualifiedAddress, (CharSequence)"registry.hub.docker.com") ? null : qualifiedAddress;
    }

    public String getQualifiedRepository() {
        StringBuilder resultBuilder = new StringBuilder();
        if (StringUtil.isNotEmpty((String)this.myAddress)) {
            resultBuilder.append(this.myAddress);
            resultBuilder.append(REPOSITORY_PARTS_SEPARATOR);
        }
        if (StringUtil.isNotEmpty((String)this.myNamespace)) {
            resultBuilder.append(this.myNamespace);
            resultBuilder.append(REPOSITORY_PARTS_SEPARATOR);
        }
        resultBuilder.append(this.myRepository);
        return resultBuilder.toString();
    }

    public String getQualifiedRepoTag() {
        return this.getQualifiedRepository() + TAG_SEPARATOR + this.getTag();
    }

    public boolean isOwnedBy(DockerRegistry registryConfiguration) {
        return StringUtil.equals((CharSequence)this.getQualifiedAddress(), (CharSequence)registryConfiguration.getAddress()) && StringUtil.equals((CharSequence)this.getNamespace(), (CharSequence)registryConfiguration.getUsername());
    }
}

