/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.registry.DockerRegistry;
import com.intellij.docker.registry.DockerRegistryManager;
import com.intellij.docker.registry.DockerRepoTag;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistrySelectionEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class PushImageConfigurable
implements Configurable {
    private JComboBox myTagComboBox;
    private JComboBox myRepositoryComboBox;
    private JPanel myMainPanel;
    private JPanel myRegistrySelectionPanelPlaceholder;
    private final DockerRepositoryModel myModel;
    private final List<DockerRepoTag> myExistingTags;
    private final RegistrySelectionEditor myRegistrySelectionEditor;
    private final JTextComponent myRepositoryEditor;

    public PushImageConfigurable(DockerRepositoryModel model, Collection<String> existingRepoTags) {
        this.myModel = model;
        Function function = s -> new DockerRepoTag((String)s);
        this.$$$setupUI$$$();
        this.myExistingTags = ContainerUtil.map(existingRepoTags, (Function)function);
        List pushableRegistries = ContainerUtil.filter(DockerRegistryManager.getInstance().getRegistries(), registry -> registry.hasUserData());
        this.myRegistrySelectionEditor = new RegistrySelectionEditor(pushableRegistries, this.getDefaultRegistry(pushableRegistries));
        this.myRegistrySelectionPanelPlaceholder.add(this.myRegistrySelectionEditor.getMainPanel());
        this.myRegistrySelectionEditor.setAccountSelectionListener(() -> this.onRegistrySelected());
        this.myRepositoryEditor = (JTextComponent)this.myRepositoryComboBox.getEditor().getEditorComponent();
        this.myRepositoryEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                PushImageConfigurable.this.onRepositoryChanged();
            }
        });
        this.onRegistrySelected();
    }

    private DockerRegistry getDefaultRegistry(List<DockerRegistry> pushableRegistries) {
        for (DockerRepoTag tag : this.myExistingTags) {
            for (DockerRegistry registry : pushableRegistries) {
                if (!tag.isOwnedBy(registry)) continue;
                return registry;
            }
        }
        return null;
    }

    private void onRegistrySelected() {
        DockerRegistry registryConfiguration = this.myRegistrySelectionEditor.getSelectedAccount();
        if (registryConfiguration == null) {
            return;
        }
        this.myRepositoryComboBox.removeAllItems();
        LinkedHashSet<String> addedItems = new LinkedHashSet<String>();
        for (DockerRepoTag existingTag : this.myExistingTags) {
            String repository;
            if (!existingTag.isOwnedBy(registryConfiguration) || !addedItems.add(repository = existingTag.getRepository())) continue;
            this.myRepositoryComboBox.addItem(repository);
        }
        if (!addedItems.isEmpty()) {
            this.myRepositoryComboBox.setSelectedItem(addedItems.iterator().next());
        }
        this.onRepositoryChanged();
    }

    private void onRepositoryChanged() {
        DockerRegistry registryConfiguration = this.myRegistrySelectionEditor.getSelectedAccount();
        if (registryConfiguration == null) {
            return;
        }
        String repository = this.myRepositoryEditor.getText();
        this.myTagComboBox.removeAllItems();
        for (DockerRepoTag existingTag : this.myExistingTags) {
            if (!existingTag.isOwnedBy(registryConfiguration) || !StringUtil.equals((CharSequence)existingTag.getRepository(), (CharSequence)repository)) continue;
            this.myTagComboBox.addItem(existingTag.getTag());
        }
    }

    @Nls
    public String getDisplayName() {
        return "Push Image";
    }

    @Nullable
    public String getHelpTopic() {
        return "Push_Image_dialog";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        DockerRegistry selectedRegistry = this.myRegistrySelectionEditor.getSelectedAccount();
        if (selectedRegistry == null) {
            throw new ConfigurationException("Registry required");
        }
        String repository = (String)ObjectUtils.tryCast((Object)this.myRepositoryComboBox.getSelectedItem(), String.class);
        if (StringUtil.isEmpty((String)repository)) {
            throw new ConfigurationException("Repository required");
        }
        String tag = (String)ObjectUtils.tryCast((Object)this.myTagComboBox.getSelectedItem(), String.class);
        if (StringUtil.isEmpty((String)tag)) {
            throw new ConfigurationException("Tag required");
        }
        this.myModel.setRegistry(selectedRegistry);
        this.myModel.setRepository(repository);
        this.myModel.setTag(tag);
    }

    public void reset() {
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Tag:");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTagComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel2.add(jComboBox2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRepositoryComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Repository:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRegistrySelectionPanelPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Registry:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

