/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.cli.DockerParseCliCallback;
import com.intellij.docker.cli.DockerParseCliConfigImpl;
import com.intellij.docker.cli.DockerParseCliConfigurable;
import com.intellij.docker.settings.DockerEnvVarsEditor;
import com.intellij.docker.settings.DockerLinksEditor;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.settings.DockerVolumeBindingsEditor;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDockerContainerSettingsEditor<T>
extends SettingsEditor<T> {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractDockerContainerSettingsEditor.class.getName()));
    private static final URL JSON_TEMPLATE_URL = AbstractDockerContainerSettingsEditor.class.getResource("/resources/container_settings.json");
    private final Project myProject;
    private JPanel myMainPanel;
    private JTextField myEntrypointField;
    private JTextField myCommandField;
    private JPanel myPortBindingsPanelPlaceHolder;
    private JCheckBox myPublishAllPortsCheckBox;
    private JPanel myLinksPanelPlaceHolder;
    private JPanel myVolumeBindingsPanelPlaceHolder;
    private JPanel myEnvVarsPanelPlaceHolder;
    private JPanel myNotificationPanel;
    private TextFieldWithBrowseButton myContainerSettingsJSONField;
    private JButton myContainerSettingsTemplateButton;
    private JButton myCliButton;
    private DockerPortBindingsEditor myPortBindingsEditor;
    private DockerLinksEditor myLinksEditor;
    private DockerVolumeBindingsEditor myVolumeBindingsEditor;
    private DockerEnvVarsEditor myEnvVarsEditor;
    private HideableDecorator myPortBindingsDecorator;
    private HideableDecorator myLinksDecorator;
    private HideableDecorator myVolumeBindingsDecorator;
    private HideableDecorator myEnvVarsDecorator;

    public AbstractDockerContainerSettingsEditor(Project project, RemoteServer server) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myContainerSettingsJSONField.addBrowseFolderListener("Container settings", "Choose container settings JSON file", null, FileChooserDescriptorFactory.createSingleFileDescriptor((String)"json"));
        this.myContainerSettingsTemplateButton.setIcon(AllIcons.ToolbarDecorator.Import);
        this.myContainerSettingsTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDockerContainerSettingsEditor.this.createContainerSettingsTemplate();
            }
        });
        this.myCliButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDockerContainerSettingsEditor.this.parseCliOptions();
            }
        });
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDockerContainerSettingsEditor.this.updatePortBindingsAvailability();
            }
        });
        this.myPortBindingsEditor = new DockerPortBindingsEditor();
        this.myPortBindingsDecorator = new HideableDecoratorEx(this.myPortBindingsPanelPlaceHolder, "Port bindings", this.myPortBindingsEditor);
        this.myLinksEditor = new DockerLinksEditor(server);
        this.myLinksDecorator = new HideableDecoratorEx(this.myLinksPanelPlaceHolder, "Links", this.myLinksEditor);
        this.myVolumeBindingsEditor = new DockerVolumeBindingsEditor(server);
        this.myVolumeBindingsDecorator = new HideableDecoratorEx(this.myVolumeBindingsPanelPlaceHolder, "Volume bindings", this.myVolumeBindingsEditor);
        this.myEnvVarsEditor = new DockerEnvVarsEditor();
        this.myEnvVarsDecorator = new HideableDecoratorEx(this.myEnvVarsPanelPlaceHolder, "Environment variables", this.myEnvVarsEditor);
    }

    private void updatePortBindingsAvailability() {
        boolean enablePortBindings = !this.myPublishAllPortsCheckBox.isSelected();
        this.myPortBindingsEditor.setEnabled(enablePortBindings);
    }

    protected void resetEditorFrom(@NotNull T runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor", "resetEditorFrom"));
        }
        DockerDeploymentConfiguration configuration = this.getConfiguration(runConfiguration);
        if (configuration == null) {
            return;
        }
        this.myContainerSettingsJSONField.setText(configuration.getSystemDependentJSONFilePath());
        this.myEntrypointField.setText(configuration.getEntrypoint());
        this.myCommandField.setText(configuration.getCommand());
        this.myPublishAllPortsCheckBox.setSelected(configuration.isPublishAllPorts());
        this.updatePortBindingsAvailability();
        this.myPortBindingsEditor.setItems(configuration.getPortBindings());
        this.myPortBindingsDecorator.setOn(configuration.isPortBindingsExpanded());
        this.myLinksEditor.setItems(configuration.getLinks());
        this.myLinksDecorator.setOn(configuration.isLinksExpanded());
        this.myVolumeBindingsEditor.setItems(configuration.getVolumeBindings());
        this.myVolumeBindingsDecorator.setOn(configuration.isVolumeBindingsExpanded());
        this.myEnvVarsEditor.setItems(configuration.getEnvVars());
        this.myEnvVarsDecorator.setOn(configuration.isEnvVarsExpanded());
    }

    protected void applyEditorTo(@NotNull T runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor", "applyEditorTo"));
        }
        DockerDeploymentConfiguration configuration = this.getConfiguration(runConfiguration);
        if (configuration == null) {
            return;
        }
        configuration.setSystemDependentJSONFilePath(this.myContainerSettingsJSONField.getText());
        configuration.setEntrypoint(this.myEntrypointField.getText());
        configuration.setCommand(this.myCommandField.getText());
        configuration.setPublishAllPorts(this.myPublishAllPortsCheckBox.isSelected());
        configuration.setPortBindings(this.myPortBindingsEditor.getItems());
        configuration.setPortBindingsExpanded(this.myPortBindingsDecorator.isExpanded());
        configuration.setLinks(this.myLinksEditor.getItems());
        configuration.setLinksExpanded(this.myLinksDecorator.isExpanded());
        configuration.setVolumeBindings(this.myVolumeBindingsEditor.getItems());
        configuration.setVolumeBindingsExpanded(this.myVolumeBindingsDecorator.isExpanded());
        configuration.setEnvVars(this.myEnvVarsEditor.getItems());
        configuration.setEnvVarsExpanded(this.myEnvVarsDecorator.isExpanded());
    }

    protected abstract DockerDeploymentConfiguration getConfiguration(@NotNull T var1);

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor", "createEditor"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myNotificationPanel = new NotificationPanel();
    }

    private void parseCliOptions() {
        Object[] envVars;
        Object[] volumeBindings;
        Object[] links;
        final DockerParseCliConfigImpl parseCliConfig = new DockerParseCliConfigImpl();
        if (!ShowSettingsUtil.getInstance().editConfigurable((Component)this.myMainPanel, (Configurable)new DockerParseCliConfigurable(parseCliConfig, this.myProject))) {
            return;
        }
        final AtomicReference<Object> errorMessageRef = new AtomicReference<Object>(null);
        final AtomicReference<Object> containerConfigRef = new AtomicReference<Object>(null);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        DockerCloudConfiguration cloudConfiguration = new DockerCloudConfiguration();
        cloudConfiguration.setDoNotConnect(true);
        ServerTaskExecutorImpl taskExecutor = new ServerTaskExecutorImpl();
        DockerCloudType.getInstance().createConnector(cloudConfiguration, (ServerTaskExecutor)taskExecutor).connect(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor$4", "connected"));
                }
                ((DockerServerRuntimeInstance)serverRuntimeInstance).parseCliOptions(parseCliConfig, new DockerAgentPathMapperImpl(AbstractDockerContainerSettingsEditor.this.myProject), new DockerParseCliCallback(){

                    @Override
                    public void succeeded(@NotNull DockerAgentContainerConfig containerConfig) {
                        if (containerConfig == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerConfig", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor$4$1", "succeeded"));
                        }
                        containerConfigRef.set(containerConfig);
                        semaphore.up();
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor$4$1", "errorOccurred"));
                        }
                        errorMessageRef.set(errorMessage);
                        semaphore.up();
                    }
                });
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor$4", "errorOccurred"));
                }
                errorMessageRef.set(errorMessage);
                semaphore.up();
            }
        });
        new Task.Modal(null, "Parsing...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/settings/AbstractDockerContainerSettingsEditor$5", "run"));
                }
                indicator.setIndeterminate(true);
                while (!indicator.isCanceled() && !semaphore.waitFor(500L)) {
                }
            }
        }.queue();
        String errorMessage = errorMessageRef.get();
        if (errorMessage != null) {
            Messages.showErrorDialog((Component)this.myMainPanel, (String)errorMessage);
            return;
        }
        DockerAgentContainerConfig containerConfig = containerConfigRef.get();
        if (containerConfig == null) {
            return;
        }
        this.myContainerSettingsJSONField.setText(parseCliConfig.getJsonPath());
        VirtualFileManager.getInstance().asyncRefresh(null);
        String[] entrypoint = containerConfig.getEntrypoint();
        if (entrypoint != null && StringUtil.isEmpty((String)this.myEntrypointField.getText())) {
            this.myEntrypointField.setText(ParametersListUtil.join((String[])entrypoint));
        }
        this.myPublishAllPortsCheckBox.setSelected(this.myPublishAllPortsCheckBox.isSelected() || containerConfig.isPublishAllPorts());
        Object[] portBindings = containerConfig.getPortBindings();
        if (portBindings != null && this.myPortBindingsEditor.getItems().isEmpty()) {
            this.myPortBindingsEditor.setItems(ContainerUtil.map((Object[])portBindings, binding -> new DockerPortBindingImpl(binding)));
        }
        if ((links = containerConfig.getLinks()) != null && this.myLinksEditor.getItems().isEmpty()) {
            this.myLinksEditor.setItems(ContainerUtil.map((Object[])links, link -> new DockerLinkImpl(link)));
        }
        if ((volumeBindings = containerConfig.getVolumeBindings()) != null && this.myVolumeBindingsEditor.getItems().isEmpty()) {
            this.myVolumeBindingsEditor.setItems(ContainerUtil.map((Object[])volumeBindings, binding -> new DockerVolumeBindingImpl(binding)));
        }
        if ((envVars = containerConfig.getEnvVars()) != null && this.myEnvVarsEditor.getItems().isEmpty()) {
            this.myEnvVarsEditor.setItems(ContainerUtil.map((Object[])envVars, envVar -> new DockerEnvVarImpl(envVar)));
        }
    }

    private void createContainerSettingsTemplate() {
        FileSaverDescriptor descriptor = new FileSaverDescriptor("Save container settings sample", "Select path to save container settings sample.", new String[]{"json"});
        FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, this.myProject);
        VirtualFileWrapper fileWrapper = saverDialog.save(this.myProject.getBaseDir(), "container_settings.json");
        if (fileWrapper == null) {
            return;
        }
        try {
            File file = fileWrapper.getFile();
            FileUtil.writeToFile((File)file, (String)FileUtil.loadTextAndClose((InputStream)JSON_TEMPLATE_URL.openStream()));
            this.myContainerSettingsJSONField.setText(file.getAbsolutePath());
            VirtualFileManager.getInstance().asyncRefresh(null);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Entrypoint:");
        jPanel5.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Command:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEntrypointField = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCommandField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myLinksPanelPlaceHolder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVolumeBindingsPanelPlaceHolder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEnvVarsPanelPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPortBindingsPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPublishAllPortsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Publish all ports");
        jPanel5.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        JPanel jPanel6 = this.myNotificationPanel;
        jPanel5.add((Component)jPanel6, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myContainerSettingsJSONField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myContainerSettingsTemplateButton = jButton2 = new JButton();
        jButton2.setText("");
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCliButton = jButton = new JButton();
        jButton.setText("CLI");
        jPanel7.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("JSON file: ");
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField2);
        jBLabel2.setLabelFor(jTextField);
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class NotificationPanel
    extends JPanel
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

        private NotificationPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.myEventDispatcher.addListener((EventListener)changeListener, (Disposable)AbstractDockerContainerSettingsEditor.this);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        public void stateChanged() {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
        }
    }

    private class HideableDecoratorEx
    extends HideableDecorator {
        public HideableDecoratorEx(JPanel panel, String title, TableWithCardEditor editor) {
            super(panel, title, false);
            this.setContentComponent(editor.getPanel());
        }

        protected void on() {
            super.on();
            ((NotificationPanel)AbstractDockerContainerSettingsEditor.this.myNotificationPanel).stateChanged();
        }

        protected void off() {
            super.off();
            ((NotificationPanel)AbstractDockerContainerSettingsEditor.this.myNotificationPanel).stateChanged();
        }
    }
}

