/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DockerPortBindingConfigurable
implements Configurable {
    private JTextField myContainerPortTextField;
    private JPanel myMainPanel;
    private JComboBox myProtocolComboBox;
    private JTextField myHostIpTextField;
    private JTextField myHostPortTextField;
    private final DockerPortBindingImpl myPortBinding;

    public DockerPortBindingConfigurable(DockerPortBindingImpl portBinding) {
        this.myPortBinding = portBinding;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return "Port bindings";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        Integer hostPort;
        int containerPort;
        String containerPortText = this.myContainerPortTextField.getText();
        if (StringUtil.isEmpty((String)containerPortText)) {
            throw new ConfigurationException("Container port required");
        }
        try {
            containerPort = Integer.parseInt(containerPortText);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Container port should be a number");
        }
        String hostPortText = this.myHostPortTextField.getText();
        if (StringUtil.isEmpty((String)hostPortText)) {
            hostPort = null;
        } else {
            try {
                hostPort = Integer.parseInt(hostPortText);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Host port should be a number");
            }
        }
        this.myPortBinding.setContainerPort(containerPort);
        this.myPortBinding.setProtocol((String)this.myProtocolComboBox.getSelectedItem());
        this.myPortBinding.setHostIp(this.myHostIpTextField.getText());
        this.myPortBinding.setHostPort(hostPort);
    }

    public void reset() {
        int containerPort = this.myPortBinding.getContainerPort();
        this.myContainerPortTextField.setText(containerPort == 0 ? "" : Integer.toString(containerPort));
        this.myProtocolComboBox.setSelectedItem(this.myPortBinding.getProtocol());
        this.myHostIpTextField.setText(this.myPortBinding.getHostIp());
        Integer hostPort = this.myPortBinding.getHostPort();
        this.myHostPortTextField.setText(hostPort == null ? "" : hostPort.toString());
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JComboBox jComboBox;
        JTextField jTextField3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Container port:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myContainerPortTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Protocol:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProtocolComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("tcp");
        defaultComboBoxModel.addElement("udp");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Host IP:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Host port:");
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostIpTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHostPortTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor(jTextField3);
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jTextField2);
        jBLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

