/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class DockerRuntimeEditorBase {
    private final String myName;
    private final ParameterizedRunnable<DockerAgentContainerConfig> myOnSave;
    private JPanel myMainPanel;
    private JButton mySaveButton;

    public DockerRuntimeEditorBase(String name, ParameterizedRunnable<DockerAgentContainerConfig> onSave) {
        this.myName = name;
        this.myOnSave = onSave;
    }

    protected final void initControls(JPanel mainPanel, JButton saveButton) {
        this.myMainPanel = mainPanel;
        this.mySaveButton = saveButton;
        this.mySaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerRuntimeEditorBase.this.save();
            }
        });
    }

    private void save() {
        DockerAgentContainerConfig config = this.createConfig();
        if (config != null) {
            UIUtil.setEnabled((Component)this.myMainPanel, (boolean)false, (boolean)true);
            this.mySaveButton.setText("Saving...");
            this.myOnSave.run((Object)config);
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public String getName() {
        return this.myName;
    }

    protected abstract DockerAgentContainerConfig createConfig();
}

