/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerApplicationRuntime;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.view.DockerTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockerTreeFilter", storages={@Storage(value="docker.xml")})
public class DockerTreeFilter
implements PersistentStateComponent<DockerTreeFilter> {
    public boolean myStoppedContainersHidden = false;
    public boolean myUntaggedImagesHidden = false;

    public static DockerTreeFilter getInstance() {
        return (DockerTreeFilter)ServiceManager.getService(DockerTreeFilter.class);
    }

    @Nullable
    public DockerTreeFilter getState() {
        return this;
    }

    public void loadState(DockerTreeFilter state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean areStoppedContainersHidden() {
        return this.myStoppedContainersHidden;
    }

    public void setStoppedContainersHidden(Boolean stoppedContainersHidden) {
        this.myStoppedContainersHidden = stoppedContainersHidden;
    }

    public boolean areUntaggedImagesHidden() {
        return this.myUntaggedImagesHidden;
    }

    public void setUntaggedImagesHidden(Boolean untaggedImagesHidden) {
        this.myUntaggedImagesHidden = untaggedImagesHidden;
    }

    public boolean acceptNode(@Nullable AbstractTreeNode node) {
        DockerApplicationRuntime appRuntime = Optional.ofNullable(node).filter(DockerTreeStructure.DockerDeploymentNode.class::isInstance).map(DockerTreeStructure.DockerDeploymentNode.class::cast).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).map(Deployment::getRuntime).filter(DockerApplicationRuntime.class::isInstance).map(DockerApplicationRuntime.class::cast).orElse(null);
        if (appRuntime != null) {
            if (appRuntime.getParent() instanceof DockerServerRuntimeInstance.ContainersApplicationGroupRuntime) {
                return this.acceptContainer(appRuntime);
            }
            if (appRuntime.getParent() instanceof DockerServerRuntimeInstance.ImagesApplicationGroupRuntime) {
                return this.acceptImage(appRuntime);
            }
        }
        return true;
    }

    public boolean acceptImage(@NotNull DockerApplicationRuntime applicationRuntime) {
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/view/DockerTreeFilter", "acceptImage"));
        }
        return !this.areUntaggedImagesHidden() || !applicationRuntime.getImageRepoTags().contains("<none>:<none>");
    }

    public boolean acceptContainer(@NotNull DockerApplicationRuntime applicationRuntime) {
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/view/DockerTreeFilter", "acceptContainer"));
        }
        return !this.areStoppedContainersHidden() || !DockerUtil.isStoppedStatus((String)applicationRuntime.getStatusText());
    }
}

