/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.docker.dockerFile.lexer;

import com.intellij.docker.dockerFile.lexer.DockerElementType;
import com.intellij.lang.ASTNode;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEntrypointExecCommandImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEnvAnyValueImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEnvCommandImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEnvRegularDeclarationImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEnvRegularValueImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileEnvUnstructuredDeclarationImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileSimpleCommandImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileStringLiteralImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileVariableRefFullImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileVariableRefPostProcessingImpl;
import com.intellij.plugins.docker.dockerFile.parser.impl.DockerFileVariableRefSimpleImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;

public interface DockerTokenTypes {
    public static final IElementType ENTRYPOINT_EXEC_COMMAND = new DockerElementType("ENTRYPOINT_EXEC_COMMAND");
    public static final IElementType ENV_ANY_VALUE = new DockerElementType("ENV_ANY_VALUE");
    public static final IElementType ENV_COMMAND = new DockerElementType("ENV_COMMAND");
    public static final IElementType ENV_REGULAR_DECLARATION = new DockerElementType("ENV_REGULAR_DECLARATION");
    public static final IElementType ENV_REGULAR_VALUE = new DockerElementType("ENV_REGULAR_VALUE");
    public static final IElementType ENV_UNSTRUCTURED_DECLARATION = new DockerElementType("ENV_UNSTRUCTURED_DECLARATION");
    public static final IElementType SIMPLE_COMMAND = new DockerElementType("SIMPLE_COMMAND");
    public static final IElementType STRING_LITERAL = new DockerElementType("STRING_LITERAL");
    public static final IElementType VARIABLE_REF_FULL = new DockerElementType("VARIABLE_REF_FULL");
    public static final IElementType VARIABLE_REF_POST_PROCESSING = new DockerElementType("VARIABLE_REF_POST_PROCESSING");
    public static final IElementType VARIABLE_REF_SIMPLE = new DockerElementType("VARIABLE_REF_SIMPLE");
    public static final IElementType ADD = new DockerElementType("ADD");
    public static final IElementType ARG = new DockerElementType("ARG");
    public static final IElementType ASSIGN = new DockerElementType("=");
    public static final IElementType CMD = new DockerElementType("CMD");
    public static final IElementType COMMA = new DockerElementType(",");
    public static final IElementType COMPOSITE_OPERATOR = new DockerElementType("COMPOSITE_OPERATOR");
    public static final IElementType COPY = new DockerElementType("COPY");
    public static final IElementType DOLLAR = new DockerElementType("$");
    public static final IElementType DOT = new DockerElementType(".");
    public static final IElementType ENTRYPOINT = new DockerElementType("ENTRYPOINT");
    public static final IElementType ENV = new DockerElementType("ENV");
    public static final IElementType EXPOSE = new DockerElementType("EXPOSE");
    public static final IElementType FLOATING_POINT_LITERAL = new DockerElementType("FLOATING_POINT_LITERAL");
    public static final IElementType FROM = new DockerElementType("FROM");
    public static final IElementType IDENTIFIER = new DockerElementType("IDENTIFIER");
    public static final IElementType INTEGER_LITERAL = new DockerElementType("INTEGER_LITERAL");
    public static final IElementType LABEL = new DockerElementType("LABEL");
    public static final IElementType LBRACKET = new DockerElementType("[");
    public static final IElementType LCURLY = new DockerElementType("{");
    public static final IElementType LPAREN = new DockerElementType("(");
    public static final IElementType MAINTAINER = new DockerElementType("MAINTAINER");
    public static final IElementType ONBUILD = new DockerElementType("ONBUILD");
    public static final IElementType OTHER_PUNCT = new DockerElementType("OTHER_PUNCT");
    public static final IElementType QUOTE = new DockerElementType("QUOTE");
    public static final IElementType RBRACKET = new DockerElementType("]");
    public static final IElementType RCURLY = new DockerElementType("}");
    public static final IElementType RPAREN = new DockerElementType(")");
    public static final IElementType RUN = new DockerElementType("RUN");
    public static final IElementType SIMPLE_OPERATOR = new DockerElementType("SIMPLE_OPERATOR");
    public static final IElementType STOPSIGNAL = new DockerElementType("STOPSIGNAL");
    public static final IElementType STRING_PART = new DockerElementType("STRING_PART");
    public static final IElementType USER = new DockerElementType("USER");
    public static final IElementType VOLUME = new DockerElementType("VOLUME");
    public static final IElementType WORKDIR = new DockerElementType("WORKDIR");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == ENTRYPOINT_EXEC_COMMAND) {
                return new DockerFileEntrypointExecCommandImpl(node);
            }
            if (type == ENV_ANY_VALUE) {
                return new DockerFileEnvAnyValueImpl(node);
            }
            if (type == ENV_COMMAND) {
                return new DockerFileEnvCommandImpl(node);
            }
            if (type == ENV_REGULAR_DECLARATION) {
                return new DockerFileEnvRegularDeclarationImpl(node);
            }
            if (type == ENV_REGULAR_VALUE) {
                return new DockerFileEnvRegularValueImpl(node);
            }
            if (type == ENV_UNSTRUCTURED_DECLARATION) {
                return new DockerFileEnvUnstructuredDeclarationImpl(node);
            }
            if (type == SIMPLE_COMMAND) {
                return new DockerFileSimpleCommandImpl(node);
            }
            if (type == STRING_LITERAL) {
                return new DockerFileStringLiteralImpl(node);
            }
            if (type == VARIABLE_REF_FULL) {
                return new DockerFileVariableRefFullImpl(node);
            }
            if (type == VARIABLE_REF_POST_PROCESSING) {
                return new DockerFileVariableRefPostProcessingImpl(node);
            }
            if (type == VARIABLE_REF_SIMPLE) {
                return new DockerFileVariableRefSimpleImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

