/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgPromptCommandExecutor;
import org.zmlx.hg4idea.provider.update.HgConflictResolver;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgUpdateCommand {
    private final Project project;
    private final VirtualFile repo;
    private String revision;
    private boolean clean;

    public HgUpdateCommand(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "<init>"));
        }
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/command/HgUpdateCommand", "<init>"));
        }
        this.project = project;
        this.repo = repo;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HgCommandResult execute() {
        HgCommandResult result;
        LinkedList<String> arguments = new LinkedList<String>();
        if (this.clean) {
            arguments.add("--clean");
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.revision)) {
            arguments.add("--rev");
            arguments.add(this.revision);
        }
        HgPromptCommandExecutor executor = new HgPromptCommandExecutor(this.project);
        executor.setShowOutput(true);
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.project);
        try {
            result = executor.executeInCurrentThread(this.repo, "update", arguments);
            if (!this.clean && HgErrorUtil.hasUncommittedChangesConflict(result)) {
                String message = "<html>Your uncommitted changes couldn't be merged into the requested changeset.<br>Would you like to perform force update and discard them?";
                if (HgUpdateCommand.showDiscardChangesConfirmation(this.project, "<html>Your uncommitted changes couldn't be merged into the requested changeset.<br>Would you like to perform force update and discard them?") == 0) {
                    arguments.add("-C");
                    result = executor.executeInCurrentThread(this.repo, "update", arguments);
                }
            }
        }
        finally {
            token.finish();
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.repo});
        return result;
    }

    public static int showDiscardChangesConfirmation(final @NotNull Project project, final @NotNull String confirmationMessage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "showDiscardChangesConfirmation"));
        }
        if (confirmationMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "confirmationMessage", "org/zmlx/hg4idea/command/HgUpdateCommand", "showDiscardChangesConfirmation"));
        }
        final AtomicInteger exitCode = new AtomicInteger();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                exitCode.set(Messages.showOkCancelDialog((Project)project, (String)confirmationMessage, (String)"Uncommitted Changes Problem", (String)"&Discard Changes", (String)"&Cancel", (Icon)Messages.getWarningIcon()));
            }
        });
        return exitCode.get();
    }

    public static void updateTo(@NotNull String targetRevision, @NotNull List<HgRepository> repos, @Nullable Runnable callInAwtLater) {
        if (targetRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRevision", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateTo"));
        }
        if (repos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repos", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateTo"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (HgRepository repo : repos) {
            VirtualFile repository = repo.getRoot();
            Project project = repo.getProject();
            HgUpdateCommand.updateRepoTo(project, repository, targetRevision, callInAwtLater);
        }
    }

    public static void updateRepoTo(@NotNull Project project, @NotNull VirtualFile repository, @NotNull String targetRevision, @Nullable Runnable callInAwtLater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        if (targetRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRevision", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        HgUpdateCommand.updateRepoTo(project, repository, targetRevision, false, callInAwtLater);
    }

    public static void updateRepoTo(final @NotNull Project project, final @NotNull VirtualFile repository, final @NotNull String targetRevision, final boolean clean, final @Nullable Runnable callInAwtLater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        if (targetRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRevision", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoTo"));
        }
        new Task.Backgroundable(project, HgVcsMessages.message("action.hg4idea.updateTo.description", targetRevision)){

            public void onSuccess() {
                if (callInAwtLater != null) {
                    callInAwtLater.run();
                }
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/command/HgUpdateCommand$2", "run"));
                }
                HgUpdateCommand.updateRepoToInCurrentThread(project, repository, targetRevision, clean);
            }
        }.queue();
    }

    public static boolean updateRepoToInCurrentThread(@NotNull Project project, @NotNull VirtualFile repository, @NotNull String targetRevision, boolean clean) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoToInCurrentThread"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoToInCurrentThread"));
        }
        if (targetRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetRevision", "org/zmlx/hg4idea/command/HgUpdateCommand", "updateRepoToInCurrentThread"));
        }
        HgUpdateCommand hgUpdateCommand = new HgUpdateCommand(project, repository);
        hgUpdateCommand.setRevision(targetRevision);
        hgUpdateCommand.setClean(clean);
        HgCommandResult result = hgUpdateCommand.execute();
        new HgConflictResolver(project).resolve(repository);
        boolean success = !HgErrorUtil.isCommandExecutionFailed(result);
        boolean hasUnresolvedConflicts = HgConflictResolver.hasConflicts(project, repository);
        if (!success) {
            new HgCommandResultNotifier(project).notifyError(result, "", "Update failed");
        } else if (hasUnresolvedConflicts) {
            new VcsNotifier(project).notifyImportantWarning("Unresolved conflicts.", HgVcsMessages.message("hg4idea.update.warning.merge.conflicts", repository.getPath()));
        }
        HgUtil.getRepositoryManager(project).updateRepository(repository);
        HgErrorUtil.markDirtyAndHandleErrors(project, repository);
        return success;
    }
}

