/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern JAVA_RUNTIME_VERSION = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?(?:_(\\d+))?(?:-(?:.*-)?b(\\d+))?.*");
    private static final Pattern GENERIC_VERSION = Pattern.compile("[^0-9]*(\\d+)\\.(\\d+)(?:\\.(\\d+))?.*");
    private final int major;
    private final int minor;
    private final int patch;
    private final int update;
    private final int build;

    public Version(int major, int minor, int patch, int update, int build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.update = update;
        this.build = build;
    }

    public static Version parseJavaRuntimeVersion(String javaRuntimeVersion) {
        Matcher matcher = Version.getMatches(JAVA_RUNTIME_VERSION, javaRuntimeVersion);
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Version.integerOrZero(matcher.group(3));
        int update = Version.integerOrZero(matcher.group(4));
        int build = Version.integerOrZero(matcher.group(5));
        return new Version(major, minor, patch, update, build);
    }

    public static Version parseVersion(String version) {
        Matcher matcher = Version.getMatches(GENERIC_VERSION, version);
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Version.integerOrZero(matcher.group(3));
        return new Version(major, minor, patch, 0, 0);
    }

    static int integerOrZero(String input) {
        return input != null ? Integer.parseInt(input) : 0;
    }

    private static Matcher getMatches(Pattern pattern, String version) {
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            String template = "Unrecognized version string '%1$s'.";
            String message = String.format("Unrecognized version string '%1$s'.", version);
            throw new IllegalArgumentException(message);
        }
        return matcher;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getUpdate() {
        return this.update;
    }

    public int getBuild() {
        return this.build;
    }
}

