/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeLocalFileTransfer
implements NodeFileTransfer {
    public static final NodeLocalFileTransfer INSTANCE = new NodeLocalFileTransfer();

    @Override
    public List<String> listDirectoryContents(@NotNull String remoteWorkingDir) throws IOException {
        if (remoteWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteWorkingDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "listDirectoryContents"));
        }
        String[] list = new File(remoteWorkingDir).list();
        if (list == null) {
            throw new IOException("Wrong local directory: " + remoteWorkingDir);
        }
        return Arrays.asList(list);
    }

    @Override
    public void copy(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        File[] files;
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "copy"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "copy"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "copy"));
        }
        File ioSourceDir = new File(sourceDir);
        File ioTargetDir = new File(targetDir);
        if (FileUtil.filesEqual((File)ioSourceDir, (File)ioTargetDir)) {
            return;
        }
        for (File file : files = ioSourceDir.listFiles()) {
            if (!names.contains(file.getName())) continue;
            FileUtil.copy((File)file, (File)new File(ioTargetDir, file.getName()));
        }
    }

    @Override
    public void fetch(@NotNull String sourceDir, @NotNull Set<String> names, @NotNull String targetDir) throws IOException {
        if (sourceDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "fetch"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "fetch"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "fetch"));
        }
        this.copy(sourceDir, names, targetDir);
    }

    @Override
    public void fetch(@NotNull String sourcePath, @NotNull String targetPath) throws IOException {
        if (sourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePath", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "fetch"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "fetch"));
        }
        FileUtil.copy((File)new File(sourcePath), (File)new File(targetPath));
    }

    @Override
    public String copyToRemoteTmpFile(@NotNull String remoteDir, String localFileName, String content) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "copyToRemoteTmpFile"));
        }
        File created = FileUtil.createTempFile((File)new File(remoteDir), (String)localFileName, null, (boolean)true);
        FileUtil.writeToFile((File)created, (String)content);
        return created.getAbsolutePath();
    }

    @Override
    public String getPathForTempFile(@NotNull String remoteDir, String localFileName) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "getPathForTempFile"));
        }
        return FileUtil.createTempFile((File)new File(remoteDir), (String)localFileName, null, (boolean)false).getAbsolutePath();
    }

    @Override
    public void grouped(@NotNull String title, @NotNull ThrowableConsumer<NodeFileTransfer, IOException> consumer) throws IOException {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "grouped"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "grouped"));
        }
        consumer.consume((Object)this);
    }

    @Override
    public void deleteRemote(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "deleteRemote"));
        }
        FileUtil.delete((File)new File(path));
    }

    @Override
    public void delete(@NotNull String dir, @NotNull HashSet<String> set) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "delete"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "delete"));
        }
        for (String name : set) {
            FileUtil.delete((File)new File(dir, name));
        }
    }

    @Override
    public boolean mkDir(@NotNull String remoteDir, String name) throws IOException {
        if (remoteDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteDir", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "mkDir"));
        }
        return FileUtil.createDirectory((File)new File(remoteDir, name));
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean hasInternalMapping() {
        return false;
    }

    @Override
    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/intellij/javascript/nodejs/NodeLocalFileTransfer", "getMappingFor"));
        }
        return localPath;
    }
}

